/*
 * xutil.c --  A couple of low level utilities needed for
 *             the X Problem Tracking System (PTS) database.
 *	       (not to be confused with ../util/util.c.)
 * Dean Collins 
 * created: Tue Oct 20 10:13:14 PDT 1992
 *
 * Modified: Dean Collins Sat Feb 12 17:31:48 1994
 * Modifications recommended by Jaap Haalboom (haalboom@prl.philips.nl).
 * Fixed a couple of minor malloc problems; Fixed return value for FixStr().
 * 
 * Modified: Dean Collins Thu Feb 24 09:18:31 1994
 * Moved FixStr, StripTrailing & StripLeading into the cloud.
 *
 * Modified: Dean Collins Fri Mar 11 17:24:18 PST 1994
 * Renamed to xutil.c to reduce confusion with ../util/util.c.  sigh.
 *
 * Modified: Dean Collins Fri Mar 18 18:29:22 1994
 * Finally switched to using dynamic memory in FormatProblem.
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <sys/types.h>          /* Common data types */
#include <sys/stat.h>           /* File status utilities */
#include <errno.h>              /* Error utilities header file */

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */

#include <X11/Intrinsic.h>      /* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>     /* Include StringDefs header file */
#include <X11/Shell.h>          /* Include the Shell header file for popups */
#include "xpts.h"               /* Xpts header file */
extern char Path[] ;

#define WORLD_WRITE  002
#define GROUP_WRITE  020
#define OWNER_WRITE 0200
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif




/******************** MODULES *************************************/
/*
______________________________________________________________________
FileExists()

FUNCTION DESCRIPTION:

     This function determines whether or not a file exists.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  10/20/92
______________________________________________________________________
*/


int
FileExists(char *fname)

     /* Interface description:
         INPUT:
	  fname - The name of the file to search for.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - TRUE if file fname exists, FALSE otherwise.
     */
      
{
     /* Internal variables: */
          /* Major */
   struct stat fileinfo ;  /* Status information record for stat() */
          /* Minor */
   /* NONE */
   int status=0 ;


   /*------------------- Start of FileExists() routine --------------------*/
#ifdef DEBUG
   printf("XPTS(xutil.c): Entering FileExists()\n") ;
#endif

     /* Get the information about the file using stat() */
   status=stat(fname, &fileinfo) ;
#ifdef DEBUG
   printf("XPTS(xutil.c): status=%d\n",status) ;
#endif

     /* If the file exists, return TRUE 
      * else return FALSE 
      */

   if (status == 0)
   {
#ifdef DEBUG
      printf("XPTS(xutil.c): %s exists.\n", fname) ;
      printf("XPTS(xutil.c): Leaving FileExists()\n") ;
#endif
      return (TRUE) ;
   }

#ifdef DEBUG
   printf("XPTS(xutil.c): %s does not exist.\n", fname) ;
   printf("XPTS(xutil.c): Leaving FileExists()\n") ;
#endif
   return(FALSE) ;

}  /*----------------------- End of FileExists() --------------------------*/


/*
______________________________________________________________________
IsWritable()

FUNCTION DESCRIPTION:

     This function determines whether or not a file is writable
by the current user.
______________________________________________________________________
UNIT TESTING:
     This function will be tested by using a combination of white-box and
black-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  10/20/92
______________________________________________________________________
*/


int 
IsWritable(char *fname)

     /* Interface description:
         INPUT:
	  fname - The name of the file to search for.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - TRUE if file is writable, FALSE otherwise.
     */
      
{
     /* Internal variables: */
          /* Major */
   struct stat fileinfo ;  /* Status information record for stat() */

          /* Minor */
   int err ;


   /*------------------- Start of IsWritable() routine --------------------*/
#ifdef DEBUG
   printf("XPTS(xutil.c): Entering IsWritable()\n") ;
#endif

     /* Get the information about the file using stat() */
   err = stat (fname, &fileinfo) ;


     /* If the file doesn't exist, return FALSE */
   if (err != 0)
   {  
#ifdef DEBUG
      printf ("Error obtaining status info of %s\n", fname) ;
      printf("XPTS(xutil.c): Leaving IsWritable()\n") ;
#endif
      return(FALSE) ;
   }


     /* If the file is world writable, return TRUE */
   if (fileinfo.st_mode & WORLD_WRITE)
   {  
#ifdef DEBUG
      printf("XPTS(xutil.c): %s is world-writable.\n",fname) ;
      printf("XPTS(xutil.c): Leaving IsWritable()\n") ;
#endif
      return (TRUE) ;
   }

     /* If the file is writable by the user's group, return TRUE */
   if ((fileinfo.st_mode & GROUP_WRITE) && (getegid() == fileinfo.st_gid))
   {  
#ifdef DEBUG
      printf("XPTS(xutil.c): %s is group-writable.\n",fname) ;
      printf("XPTS(xutil.c): Leaving IsWritable()\n") ;
#endif
      return (TRUE) ;
   }

     /* If the file is writable by the user, return TRUE */
   if ((fileinfo.st_mode & OWNER_WRITE) && (geteuid() == fileinfo.st_uid))
   {  
#ifdef DEBUG
      printf("XPTS(xutil.c): %s is owner-writable.\n",fname) ;
      printf("XPTS(xutil.c): Leaving IsWritable()\n") ;
#endif
      return (TRUE) ;
   }


     /* Otherwise, return FALSE.  The file is not writable by the user. */

#ifdef DEBUG
   printf("XPTS(xutil.c): %s is not writable.\n",fname) ;
   printf("XPTS(xutil.c):  Leaving IsWritable()\n") ;
#endif
   return(FALSE) ;

}  /*----------------------- End of IsWritable() --------------------------*/

/* end of xutil.c */
