/*
 * pts-repagain.c -- PTS CGI utility to generate a form for reporting
 *                   a problem again.
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */



#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "patchlevel.h"         /* For version info. */
#include "html.h"		/* A couple of HTML-related routines */


/******************** MODULES *************************************/

/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the main routine for this program.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
main(int   argc,
     char *argv[])

     /* Interface description:
         INPUT:
          argc  - The number of command-line arguments.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  Non-zero is error.
     */

{
     /* Internal variables: */

          /* Major */
    int count=0 ;
    post_entry entries[MAX_ENTRIES];
    char *path=NULL ;
    char *prid=NULL ;
    char *email=NULL ;
    char *node=NULL ;

          /* Minor */
    int x=0 ;

   /*----------------- Start of main() routine ------------------*/

#   ifdef DEBUG
    freopen ("/tmp/debug", "w", stderr) ;
    zdebug1("Debug output for: %s\n\n", argv[0]) ;
#   endif

    count = PostQuery (stdout, entries, MAX_ENTRIES) ;

    for(x=0; x < count; x++)
    {  if (strcmp("email", entries[x].name) == 0)    email = entries[x].value ;
       if (strcmp("node",  entries[x].name) == 0)    node  = entries[x].value ;
       if (strcmp("type",  entries[x].name) == 0)    path  = entries[x].value ;
       if (strcmp("prid",  entries[x].name) == 0)    prid  = entries[x].value ;
    }

    HTMLHeader (stdout, "Problem Tracking System", "Report Problem Again", "") ;

    printf("Problem type: %s<BR>%c", path, 10) ;
    printf("Problem ID: %s<BR>%c", prid, 10) ;
    printf("E-mail address: %s<BR>%c", email, 10) ;
    printf("Node: %s<P>%c", node, 10) ;

	/* Are any of the required fields empty??? */
    if ( ! (strlen(path) && strlen(prid) && strlen(email) && strlen(node)))
    {
	printf ("ERROR reporting the problem again:<P>%c",10) ;
	printf ("Not all required fields were provided.<P>%c", 10) ;
    }
    else
    {  if (ReportAgainPRID(path,prid,email,node))
       {
	   printf ("You have been added to the list of reporters for this problem.  %c", 10) ;
	   printf ("You will be notified when the problem is solved, and the %c", 10) ;
	   printf ("problem solution will be e-mailed to you.  %c", 10) ;
	   printf ("<P>%c", 10) ;
	   printf ("<I>NOTE:  There will be a short delay before your name appears %c", 10) ;
	   printf ("in the list of reporters shown in the Web page for this problem.</I><P>%c", 10) ;
       }
       else
       {
	    printf ("ERROR reporting the problem again:<P>%c",10) ;
/*CLD*/     printf ("<PRE>%s</PRE><P>%c", CloudStrerror(), 10) ;
       }
    }

    HTMLFooter(stdout) ;

}  /*--------------------- End of main() ------------------------*/


/* end of pts-repagain2.c */

