/*
 * pts-append.c -- PTS CGI utility to generate a form for reporting a problem.
 */

/*
 * Copyright (c) 1995 Dean Collins.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of Dean Collins not
 * be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission.  Dean Collins
 * makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <errno.h>		/* Error utilities header file */
#include <sys/param.h>		/* System parameters header file */
#include <string.h>
#include "pts.h"
#include "html.h"		/* A couple of HTML-related routines */
#include "zdbm.h"		/* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"		/* Nebulous Cloud error rtn. header file */
#include "config.h"		/* Config. file parser header file */
#include "patchlevel.h"		/* For version info. */

struct Full_path * SortLeaves(struct Full_path *list) ;


/******************** MODULES *************************************/

/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:

     This function is the main routine for this program.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins                      Date: 6/95
______________________________________________________________________
*/

int
main (int   argc,
      char *argv[])

     /* Interface description:
         INPUT:
          argc  - The number of command-line arguments.
          argv  - An array of command-line arguments.
         OUTPUT:
          None.
         RETURN VALUE:
          int   - Status flag.  Non-zero is error.
     */
{
     /* Internal variables: */

          /* Major */
    post_entry entries[MAX_ENTRIES];
    int count=0;
    char *Path=NULL ;
    char *Summary=NULL ;
    char *Desc=NULL ;
    char *Node=NULL ;
    char *Reporter=NULL ;
    char *Priority=NULL ;
    signed char Priority_Value=0 ;
    char cmd[1024] ;
    char *TempName=NULL ;
    char str[1024] ;
    FILE *fp=NULL ;
    char hostname[MAXHOSTNAMELEN];
   ProblemTree *ProbTree = NULL ;       /* The tree of problem types. */
   UserInfo UserInfoRec ;               /* Information about the user. */
   struct Full_path pathlist ;
   struct Full_path *p ;


          /* Minor */
   char *frm=NULL ;

   /*----------------- Start of main() routine ------------------*/

#if 0
#   ifdef DEBUG
    freopen ("/tmp/debug", "w", stderr) ;
    zdebug1("Debug output for: %s\n\n", argv[0]) ;
#   endif
#endif

    zdebug_init() ;


    count = PostQuery (stdout, entries, MAX_ENTRIES) ;

    HTMLHeader (stdout, "Problem Tracking System", "PTS Problem Report", "") ;

    printf("<FORM METHOD=\"POST\" ACTION=\"%s/pts-report\">%c", CGIBIN_URL, 10) ;
    printf("<P>%c",10) ;

    printf("Summary: <INPUT SIZE=60 NAME=\"Summary\">%c",10) ;
    printf("<BR>%c",10) ;

    printf("E-mail:%c", 10) ;
    frm=getenv("HTTP_FROM") ;
    printf("<INPUT SIZE=30 NAME=\"Email\"") ;
    if (frm) printf(" VALUE=\"%s\"", frm) ;
    printf(">%c", 10) ;


    gethostname(hostname,MAXHOSTNAMELEN);
    printf("Host: <INPUT SIZE=25 NAME=\"Host\" VALUE=\"%s\">%c",hostname,10) ;

    printf("%c",10) ;
    printf("<P>%c",10) ;

    printf("Type:%c",10) ;
    printf("<BR>%c",10) ;
    printf("<SELECT NAME=\"Type\" SIZE=5 WIDTH=60>%c",10) ;
    printf("%c",10) ;
    printf("%c",10) ;

    zdebug("calling Setup()...\n") ;
/*CLD*/   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
      exit(1);
   }
   zdebug("returned from Setup()...\n") ;
   zdebug1("\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag);
   zdebug1("\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
   zdebug1("\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;

        /* Get the problem tree into a list of leaves more easily printed.*/
        /* Then print the list of problem types (leaves only.) */
/*CLD*/  TraverseLeaves(ProbTree, &pathlist) ;
   SortLeaves(&pathlist) ;
   
   for (p = &pathlist; p != NULL; p = p->next)
   {
        if (p->path && strcmp (p->path, "") != 0 )
            printf("<OPTION>  %s%c", p->path, 10) ;
	zdebug1("\t<OPTION>  %s\n", p->path) ;
   }


    printf("%c",10) ;
    printf("</SELECT>%c",10) ;
    printf("<P>%c",10) ;


    printf("%c",10) ;
    printf("%c",10) ;
    printf("Description:%c",10) ;
    printf("<BR>%c",10) ;
    printf("<TEXTAREA NAME=\"Description\" ROWS=8 COLS=65> </TEXTAREA>%c",10) ;
    printf("<P>%c",10) ;
    printf("%c",10) ;

#ifdef DO_PRIORITY
    printf("<SELECT NAME=\"Priority\">%c",10) ;
    printf("<OPTION> 		High Priority%c",10) ;
    printf("<OPTION SELECTED>	Normal Priority%c",10) ;
    printf("<OPTION>		Low Priority%c",10) ;
    printf("</SELECT>%c",10) ;
#endif

/*    printf("<P>%c",10) ;
    printf("%c",10) ;
    printf("To submit the problem, press this button:%c",10) ;
*/
    printf("<INPUT TYPE=\"submit\" VALUE=\"Submit Problem\">%c",10) ;
    printf("<INPUT TYPE=\"reset\" VALUE=\"Clear Form\">%c",10) ;
    printf("<P>%c",10) ;
    printf("%c",10) ;
    printf("</FORM>%c",10) ;

    HTMLFooter (stdout) ;

}  /*--------------------- End of main() ------------------------*/





struct Full_path *
SortLeaves(struct Full_path *list)
{

	/* Uses selection sort.  Not best choice, but simple & good enough. */

	struct Full_path *x=NULL ;
	struct Full_path *y=NULL ;
	struct Full_path *next=NULL ;
	struct Full_path *oldnext=NULL ;
	struct Full_path *old_y=NULL ;
	struct Full_path *tmp1=NULL ;
	struct Full_path *tmp2=NULL ;
	struct Full_path *i=NULL ;

	/*BEFORE:*/
	for (x=list; x; x=x->next)
	   zdebug1("BEFORE: %s\n", x->path) ;


	/* Find the smallest string and place it at the head */
	x = y = list ;
	while (x)
	{
	   if (strcmp(x->path, y->path) < 0)
	   {
	      y = x ;
	   }
	   x = x->next ;
	}

	if (y != list)
	{
	   char path[DBPATHLEN];
	   nl_strncpy(path, list->path, DBPATHLEN) ;
	   nl_strncpy(list->path, y->path, DBPATHLEN) ;
	   nl_strncpy(y->path, path, DBPATHLEN) ;
	}

	zdebug1("Smallest is %s\n", list->path) ;



	x = list ;

	while (x)
	{
	   next = x -> next ;
	   if (next)
	   {
	      zdebug1("Considering %s\n", next->path) ;
	      y = next->next ;
	   }
	   else y = NULL ;

           oldnext = x ;
	   old_y = next ;
			/* Find the "smallest" string after x */
	   while (y)
	   {
	      if (strcmp(y->path, next->path) < 0)
	      {
		 oldnext = old_y ;
	   	 next = y ;
	      }
	      old_y = y ;
	      y = y->next ;
	   }
	   zdebug1("Next smallest is %s\n", next->path) ;

	   if (next && next != x->next)  /* Have we found a better one? */
	   {
	      zdebug2("%s looks better than %s\n", next->path, x->next->path) ;

			/* If so, swap next and x->next in the list*/

	      if (oldnext)
	         oldnext->next = next->next ;
	      next->next = x->next ;
	      x->next = next ;

	      zdebug1("Chose %s\n", x->next->path) ;

	      	/*DURING:*/
	      /*for (i=list; i; i=i->next)
	         zdebug1("\tDURING: %s\n", i->path) ;*/

   	   }

   	   x = next ;

	}


	/*AFTER:*/
	for (x=list; x; x=x->next)
	   zdebug1("AFTER: %s\n", x->path) ;


}


/* end of pts-post.c */

