/*
 * fmtprobhtml.c --  A utility needed for formatting
 *             problems for the X Problem Tracking System (PTS) database.
 *
 * Dean Collins 
 * created: Fri Jun  2 15:14:48 PDT 1995
 * Moved FormatProbHTML() from neb_cld/formatprob.c to here since it seems
 * to make more sense here, plus building/linking is easier if it's over here.
 */

/*
 * Copyright (c) 1992,1993,1994,1995 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#ifndef SYSV
#include <sys/types.h>		/* Common data types */
#endif
#include <sys/stat.h>		/* File status utilities */
#include <errno.h>		/* Error utilities header file */

#include "zdbm.h"		/* Zombie Database Manager header file */
#include "cloud.h"		/* Nebulous Cloud header file */
#include "clouderror.h"		/* Nebulous Cloud error rtn. header file */




/******************** MODULES *************************************/
/*
______________________________________________________________________
FormatProblemHTML()

FUNCTION DESCRIPTION:

     This function will format a problem_record into a single string
containing HTML control codes for your Web viewing pleasure.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date: 3/8/95
	Stole code from FormatProblem() and mutated it.
	"Mutant Zombies on the loose!  Story at 11..."
______________________________________________________________________
*/


int
FormatProblemHTML(FILE *fp, problem_record *problem, char *path)

     /* Interface description:
         INPUT:
          fp            - The file pointer to send formatted problem to.
          problem	- The problem to format.
         OUTPUT:
          None.
         RETURN:
          char *	- The formatted problem.
     */
{
     /* Internal variables: */
          /* Major */
      /* NONE */
          /* Minor */
      reporter_record *reporter=NULL ;
      int num_rep ;
      int i,j,buflen ;
      int status ;
      reopened_record *ReopenedRec=NULL ;
      char tmpstr[1024] ;


   /*------------ Start of FormatProblemHTML() routine -------------*/

   zdebug("Entering FormatProblemHTML()\n") ;

   if (problem==NULL)
      return ;

   tmpstr[0] = '\0' ;


   status = problem->status ;

   if (status == REOPENED)
   {  /* Assign ReopenedRec and fill in path from it */
      ReopenedRec=(reopened_record *)(problem->reop_rec) ;
      strcpy(path, ReopenedRec->db_path) ;
   }

   zdebug1("FormatProblemHTML() -- problem->status = %d\n", status) ;


     /*----------Header stuff...----------*/

   HTMLHeader (fp, "Problem Tracking System", "Problem Log", HTML_REFRESH) ;


     /*---------- Show the problem type ----------*/

   fprintf (fp, "<STRONG>Problem Type:</STRONG> ") ;
   fprintf (fp, "<A HREF=\"%s/db/%s/\">", HTDOCS_URL, path) ;

   if (strncmp(ROOTSTR,path,strlen(ROOTSTR)) == 0)
/*CLD*/ fprintf (fp, "/%s", FixPath(path)) ;
   else fprintf (fp, "/%s", path) ;
   fprintf (fp, "</A><BR>%c", 10) ;


     /*---------- Show the problem status ----------*/

   fprintf (fp, "<STRONG>Status:</STRONG> ") ;

   if (status == SOLVED)
   {	fprintf (fp, "<A HREF=\"%s/b/solved.html\">Solved</A>", HTDOCS_URL) ;
   }
   else if (status == UNSOLVED)
   {	fprintf (fp, "<A HREF=\"%s/db/unsolved.html\">Unsolved</A>", HTDOCS_URL) ;
   }
   else if (status == REOPENED)
	fprintf (fp, "Reopen Request") ;
   else
   {  fprintf (stderr,"FormatProblemHTML(): Error in problem status!\n") ;
      fprintf (fp, "(Unknown)") ;
   }
   fprintf (fp, "<BR>%c", 10) ;


     /*---------- Add priority ---------*/
#  ifdef DO_PRIORITY
   fprintf (fp, "<STRONG>Priority:</STRONG> %s<BR>%c", sctoa(problem->priority), 10) ;
#  endif

     /*---------- Add summary ----------*/
   fprintf (fp, "<STRONG>Summary:</STRONG> %s<P>%c", problem->short_description, 10) ;

     /*---------- Add the reporters ----------*/

   fprintf (fp, "<HR>%c", 10) ;
   fprintf (fp, "<H3>Reporters:</H3>%c", 10) ;
   fprintf (fp, "<PRE>%c", 10) ;

	/*----- Add column headers -----*/
   fprintf (fp, "   %-*s %-*s%s%c", NAMELEN, "REPORTER", NODELEN, "NODE", "DATE/TIME", 10) ;
   fprintf (fp, "   %-*s %-*s%s%c", NAMELEN, "--------", NODELEN, "----", "---------", 10) ;

	/*----- Add reporters list -----*/
   if (status == SOLVED)
   {  reporter = problem->old_reporter_list ;
      num_rep = problem->num_old_rep ;
   }
   else if (status == UNSOLVED)
   {  reporter = problem->reporter_list ;
      num_rep = problem->num_rep ;
   }
   else if (status == REOPENED)
   {  reporter = &(ReopenedRec->rep_rec) ; /*hehe*/
      num_rep = 1 ;
   }

   if (reporter != NULL)
      for (i=0; i<num_rep; ++i)
      {  /* Add the reporter name */

         zdebug("FormatProblemHTML(): appending reporter record:\n") ;
         zdebug1("\treporter\t- %s\n", (reporter[i]).account_name) ;
         zdebug1("\tnode\t- %s\n", (reporter[i]).node_name) ;
         zdebug1("\tdate\t- %s\n", (reporter[i]).date_time) ;

         fprintf (fp, "   ") ;
         fprintf (fp, "<A HREF=\"mailto:%s\">", (reporter[i]).account_name) ;
/*ZDBM*/ nl_strncpy(tmpstr, (reporter[i]).account_name, NAMELEN) ;
         fprintf (fp, tmpstr) ;
         fprintf (fp, "</A> ") ;
         tmpstr[0] = '\0' ;
         buflen=strlen((reporter[i]).account_name) ;
         for (j=buflen; j<NAMELEN; ++j)
            strcat(tmpstr, " ") ;
         fprintf (fp, tmpstr) ;

         /* Add the reporter's node */
	 fprintf (fp, "<A HREF=\"telnet://") ;
         fprintf (fp, (reporter[i]).node_name) ;
	 fprintf (fp, "/\">") ;
/*ZDBM*/ nl_strncpy(tmpstr, (reporter[i]).node_name, NODELEN) ;
         fprintf (fp, tmpstr) ;
	 fprintf (fp, "</A>") ;
         tmpstr[0] = '\0' ;
         buflen=strlen((reporter[i]).node_name) ;
         for (j=buflen; j<NODELEN; ++j)
            strcat(tmpstr, " ") ;
         fprintf (fp, tmpstr) ;
   
         /* Add the reporting date */
         fprintf (fp, "%s", (reporter[i]).date_time) ;


         /* Add EOL */
         fprintf (fp, "\012") ;
      }
#ifdef DEBUG
   else zdebug("FormatProblemHTML():  reporters list was NULL!\n") ;
#endif

   fprintf (fp, "</PRE><P>%c", 10) ;

     /*---------- Report Again -------------------*/
   if (status == UNSOLVED)
#if 0
   {   fprintf (fp, "<A HREF=\"%s/pts-repagain?type=%s&prid=%s\">",
		CGIBIN_URL, FixPath(path), problem->prid) ;
       fprintf (fp, "Report Again</A>%c", 10) ;
   }
#else
   {
      fprintf (fp, "<FORM METHOD=\"GET\" ACTION=\"%s/pts-repagain\">%c", 
		CGIBIN_URL, 10) ;
      fprintf (fp, "<INPUT TYPE=\"hidden\" NAME=\"type\" VALUE=\"%s\">%c",
		FixPath(path), 10) ;
      fprintf (fp, "<INPUT TYPE=\"hidden\" NAME=\"prid\" VALUE=\"%s\">%c",
		problem->prid, 10) ;
      fprintf (fp, "<INPUT TYPE=\"submit\" VALUE=\"Me Too!\">%c", 10) ;
      fprintf (fp, "</FORM>%c", 10) ;
   }

#endif


     /*---------- Add problem log ----------*/
   fprintf (fp, "<HR>%c", 10) ;
   if (status == REOPENED)
   {  fprintf (fp, "<H3>%s</H3><BR>%c", REOPEN_REQ_STR, 10) ;
      fprintf (fp, "<PRE>%c", 10) ;
      fprintf (fp, "%s\n", ReopenedRec->reasons_log) ;
      fprintf (fp, REOPEN_REQ_STR2) ;
      fprintf (fp, "</PRE><BR>%c", 10) ;
   }
   fprintf (fp, "<H3>Problem Log:</H3>") ;
   fprintf (fp, "<PRE>%c", 10) ;
   fprintf (fp, "PROBLEM DESCRIPTION%c", 10) ;
   fprintf (fp, "%s", problem->log_file) ;
   fprintf (fp, "</PRE>%c", 10) ;

     /*---------- Append to Log -------------------*/

   if (status == UNSOLVED)
#if 0
   {   fprintf (fp, "<A HREF=\"%s/pts-append?type=%s&prid=%s\">",
		CGIBIN_URL, FixPath(path), problem->prid) ;
       fprintf (fp, "Make Log Entry</A>%c<P>%c", 10, 10) ;
   }
#else
   {
      fprintf (fp, "<FORM METHOD=\"GET\" ACTION=\"%s/pts-append\">%c", 
		CGIBIN_URL, 10) ;
      fprintf (fp, "<INPUT TYPE=\"hidden\" NAME=\"type\" VALUE=\"%s\">%c",
		FixPath(path), 10) ;
      fprintf (fp, "<INPUT TYPE=\"hidden\" NAME=\"prid\" VALUE=\"%s\">%c",
		problem->prid, 10) ;
      fprintf (fp, "<INPUT TYPE=\"submit\" VALUE=\"Make Log Entry\">%c", 10) ;
      fprintf (fp, "</FORM>%c", 10) ;
   }

#endif


      /* Trailer information....*/
   HTMLFooter(fp) ;

   zdebug("Leaving FormatProblemHTML()\n") ;

}  /*-------- End of FormatProblemHTML() ---------------------------*/


/* end of fmtprobhtml.c */
