/*
 * writebuf.c --   Write a specified number of bytes to a file.
 *
 * Dean Collins 
 * created: Sat Mar 12 23:32:53 1994
 *
 * Modified: Dean Collins Sun Jan 15 02:06:36 PST 1995
 * Changed DEBUG output so it goes to stderr.
 */

/*
 * Copyright (c) 1994 Dean Collins.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of
 * Dean Collins not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  
 * Dean Collinss make no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <string.h>		/* String and memory functions header file.*/
#include <errno.h>		/* Error utilities header file */
#ifndef SYSV
#include <sys/types.h>		/* Common data types */
#endif
#include <sys/stat.h>		/* File status utilities */

#ifndef SYSV

#include <sys/file.h>		/* Low-level file I/O */
#include <limits.h>		/* Common system limits */
#ifdef linux
#include <unistd.h>		/* Standard Unix definitions */
#endif /* linux */
/* end not system 5 */

#else /* it is system 5 */

#include <strings.h>		/* String and memory functions header file.*/
#include <unistd.h>		/* Standard Unix definitions */
#include <fcntl.h>		/* File control */

#endif /* system 5 */

/* No non-system includes should be here, other than util.h. */
#include "util.h"		/* Misc. low-level utilities */


#ifdef DEBUG
#define MYDEBUG(a,b,c,d,e) fprintf(stderr,a,b,c,d,e)
#else
#define MYDEBUG(a,b,c,d,e) 
#endif


/******************** MODULES *************************************/
/*
______________________________________________________________________
WriteBuf()

FUNCTION DESCRIPTION:

     This function writes a specified number of bytes to
a file descriptor.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date: 3/12/94
______________________________________________________________________
*/


int WriteBuf(int   fd,
             char *buf,
             int   count)

     /* Interface description:
         INPUT:
          fd     - The output file descriptor.
          buf    - The buffer to write.
          count  - Number of bytes to write.
         OUTPUT:
          None.
         RETURN VALUE:
          int    - Number of bytes successfully written.
		   If -1 see errno for error info.
     */
{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
   int cur=0 ;
   int done=0 ;
   int n=0 ;

     /*----------------- Start of WriteBuf() routine ------------------*/

		/* Repeatedly call write() until the buffer is written.  */
   MYDEBUG("num bytes to write = %d\n",count,0,0,0) ;
   while(cur<count && !done)
   {  n = write(fd, buf+cur, count-cur) ;
      MYDEBUG("num bytes written = %d (%d total)\n",n,cur+n,0,0) ;
      if (n>0)
      {
	 cur += n ;
      }
      else if (n == -1)
      {  MYDEBUG("error %d: %s\n", errno, strerror(errno), 0, 0) ;
         done = 1 ;
         if (cur==0) cur = -1 ;
      }
      else done = 1 ;
   }

   MYDEBUG("WriteBuf returning %d\n", cur, 0, 0, 0) ;
   return cur ;

}  /*--------------------- End of WriteBuf() ------------------------*/

/* End of writebuf.c */

