/*
 * str.c --   A couple of common string functions.
 *
 * Dean Collins 
 * created: Thu Feb 24 09:19:43 1994
 * Moved FixStr, StripLeading, & StripTrailing from xpts/util.c
 *
 * Modified: Dean Collins Sun Jan 15 02:06:36 PST 1995
 * Changed DEBUG output so it goes to stderr.
 */

/*
 * Copyright (c) 1992,1993,1994 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>             /* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <sys/types.h>          /* Common data types */
#include <sys/stat.h>           /* File status utilities */
#include <errno.h>              /* Error utilities header file */

#include "util.h"



/******************** MODULES *************************************/

/*
______________________________________________________________________
FixStr()

FUNCTION DESCRIPTION:

     This function "fixes" strings so they don't contain new-lines
and strips off leading and trailing white-space.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/13/93
______________________________________________________________________
*/


char *FixStr(char *str)

     /* Interface description:
         INPUT:
          str    - The string to fix.
         OUTPUT:
          None.
         RETURN VALUE:
          char * - The fixed string.  This is static data, and must
			be copied to be used.
     */

{
     /* Internal variables: */
          /* Major */
	  /* NONE */
          /* Minor */
   static char *tmpstr=NULL ;
   char *tmpstr2 ;
   int i ;


   /*------------------- Start of FixStr() routine --------------------*/

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): FixStr() str(before)='%s'\n",str) ;
#endif

   if ( strlen(str) == 0 ) return NULL ; /* Return val. fixed 2/12/94 DC*/

   if (tmpstr) free(tmpstr) ;
   tmpstr = malloc(strlen(str)+1) ;	/* "+1" added 2/12/94 DC */
   strcpy(tmpstr,str) ;

   for (i=0; tmpstr[i] != '\0'; ++i)    /* Nuke newlines */
      if (tmpstr[i] == '\n')
         tmpstr[i] = ' ' ;

   tmpstr2 = StripLeading(StripTrailing(tmpstr)) ;

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): FixStr() str(after)='%s'\n",tmpstr2) ;
#endif

   return(tmpstr2) ;

}  /*-------- End of FixStr() ---------------------------*/



/*
______________________________________________________________________
StripLeading()

FUNCTION DESCRIPTION:

     This function removes leading spaces and tabs from a string.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/13/93
______________________________________________________________________
*/


char *StripLeading(char *str)

     /* Interface description:
         INPUT:
          str    - The string to strip.
         OUTPUT:
          None.
         RETURN VALUE:
          char * - The stripped string.
     */

{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
   char *c ;
   int i ;


   /*---------------- Start of StripLeading() routine -----------------*/

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): StripLeading() str(before)='%s'\n",str) ;
#endif

        /* strip leading spaces.  c will point to the first non-space
         * and non-tab character in tmpstr.
         */
   for (c=str,i=0;
                (str[i]==' ' || str[i]=='\t') && i<strlen(str) ;
                ++c, ++i)
        ; /*nothing*/

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): StripLeading() str(after)='%s'\n",c) ;
#endif

   return(c) ;

}  /*----------End of StripLeading() --------------------*/


/*
______________________________________________________________________
StripTrailing()

FUNCTION DESCRIPTION:

     This function removes trailing spaces and tabs from a string.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  2/13/93
______________________________________________________________________
*/


char *StripTrailing(char *str)

     /* Interface description:
         INPUT:
          str    - The string to strip. 
         OUTPUT:
          None.
         RETURN VALUE:
          char * - The stripped string.  This data is static and must
		   be copied to be used.
     */

{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
   static char *tmpstr=NULL ;
   int i ;


   /*---------------- Start of StripTrailing() routine -----------------*/

   if (tmpstr) free(tmpstr) ;
   tmpstr = malloc(strlen(str)+1) ;	/* "+1" added 2/12/94 DC */
   strcpy(tmpstr,str) ;

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): StripTrailing() str(before)='%s'\n",tmpstr) ;
#endif
        /* strip trailing spaces and tabs */
   for (i=strlen(tmpstr)-1;
                i>=0 && (tmpstr[i]==' ' || tmpstr[i]=='\t');
                tmpstr[i--]='\0')
        ; /*nothing*/

#ifdef DEBUG
   fprintf(stderr,"XPTS(util.c): StripTrailing() str(after)='%s'\n",tmpstr) ;
#endif

   return(tmpstr) ;

}  /*----------End of StripTrailing() --------------------*/


/*
______________________________________________________________________
StrTail()

FUNCTION DESCRIPTION:

     This function returns the last portion of a string.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  1/7/95
______________________________________________________________________
*/


char *StrTail(char *s, int n)

     /* Interface description:
         INPUT:
          s      - The string return the tail of.
	  n	 - The maximum number of characters of s to return.
         OUTPUT:
          None.
         RETURN VALUE:
          char * - The tail string.  This is a pointer to a substring of s.
     */

{
     /* Internal variables: */
          /* Major */
   int len ;	/* The length of s */
   char *t ;	/* The substring of s */
          /* Minor */
          /* NONE */


   /*---------------- Start of StrTail() routine -----------------*/

#ifdef DEBUG
   fprintf(stderr, "Entering StrTail()...\n") ;
#endif

   len = strlen(s) ;
   if (len <= n)
        t = s ;
   else t = &(s[len-n]) ;

#ifdef DEBUG
   fprintf(stderr, "Leaving StrTail()...\n") ;
#endif

return t ;

}  /*----------End of StrTail() --------------------*/



/* end of str.c */
