/* Author:  Luke Sheneman  */

/*
 * Copyright (c) 1995,1994 Dean Collins.
 * Copyright (c) 1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of the University of Idaho
 * Dean Collins and Luke Sheneman not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written 
 * prior permission.  The University of Idaho, Luke Sheneman and Dean Collins 
 * make no representations about the suitability of this software for 
 * any purpose.  It is provided "as is" without express or implied warranty.
 *  
 * THE UNIVERSITY OF IDAHO, LUKE SHENEMAN, AND DEAN COLLINS  DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * LUKE SHENEMAN OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Modified: Dean Collins Sun Jun 12 20:29:40 1994
 * Added IsLeaf() function.  This seems to be the least-inappropriate
 * source file to place it in.
 */


/* The following functions are defined in subtree.c:
 *
 * FreeParts() - frees an array of strings which was created by BreakUpPath().
 * SubTree() - returns a pointer to a subtree of the problem tree given the
 *	tree and a path to the desired tree.
 * IsLeaf() - determines if a path is a leaf in a problem tree.
 * TraverseList() - Traverses a linked list of Full_path structures.
 *                  (Moved from tester.c, RDC, Thu Jun 16 17:39:32 1994)
 *                  (Modified paramater list, RDC, Sun Mar  5 19:29:16 PST 1995)
 *
 */


#include <stdio.h>
#include "zdbm.h"
#include "cloud.h"
#include "clouderror.h"


void FreeParts(parts)
char *parts[MAXBRANCHES];
{
	int loop;

	cld_errno=0;

	for(loop=0;loop<MAXBRANCHES;loop++)
		free(parts[loop]);
}


ProblemTree *SubTree(tree,ppath)
ProblemTree *tree;
char ppath[DBPATHLEN];
{
        ProblemTree *subtree,*current;
        char *parts[MAXBRANCHES];
        char newpath[DBPATHLEN];
        int loop=0;

	cld_errno=0;

        current=tree;
        strcpy(newpath,ppath);
        strcat(newpath,"/");

        BreakUpPath(newpath,parts);
        if(!strcmp(parts[0],ROOTSTR))
                if(!strcmp(parts[1],""))
                        return(tree);
                else
                        loop++;

        while(strcmp(parts[loop],""))
        {
                subtree=FindBranch(current,parts[loop]);
                if(subtree)
                {
                        current=subtree;
                        loop++;
                }
                else
		{
			cld_errno=CLD_ERR34;
			FreeParts(parts);
                        return(NULL);
		}
        }
	FreeParts(parts);
        return(subtree);
}



/*
______________________________________________________________________
IsLeaf()

FUNCTION DESCRIPTION:

	This function determines if a path is a leaf in a problem tree.

______________________________________________________________________
UNIT TESTING:
     This function has been tested by using white-box tests.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date:  6/11/94
______________________________________________________________________
*/

int IsLeaf(tree, path)
ProblemTree *tree ;
char *path ;
{
   ProblemTree *subtree ;

	/* Find the node in the tree corresponding to path. */
   subtree = SubTree(tree, path) ;
   if (subtree == NULL)  /* path not in tree, so it's not a leaf. */
      return 0 ;

	/* If node has any children it's not a leaf. */
   return ( (subtree->subhead) == 0) ;

}



/* Prints out all the paths in a problem tree.  Moved from tester.c.  */

void TraverseList(fp,path)
FILE *fp;
struct Full_path *path;
{
	struct Full_path *t;

	cld_errno=0;

	t=path;

	while(t)
	{
		if ((t->path)[0] != '\0')
			fprintf(fp,"%s\n",t->path);

		t=t->next;
	}	

}

