/* Author:  Luke Sheneman.  */

/* Modified: Dean Collins Thu Feb 24 16:08:01 1994
 * Changed handling of mail command.  Not a #define anymore, but a
 * global (ick!) variable.  Also added code for SysopList.
 * 
 * Modified: Dean Collins Tue Mar 01 15:55:12 1994
 * Added StringListRec definiton.  Used for arbitrary linked lists of strings
 * of at most COMPLETEPATHLEN characters..
 *
 * Modified Dean Collins Sat Mar 12 09:48:44 1994
 * Moved str.c to ../util.  Removed prototypes from this file.
 *
 * Modified: Dean Collins Fri Apr 08 21:01:09 1994
 * SUMMARY_DESC_LEN has been added, which is the maximum length of
 * the summary description strings (like "  (SOLVED)", etc.)
 *
 * Modified: Dean Collins Thu Jun 16 17:45:35 1994
 * Moved TraverseList() here from tester.c.  Maybe should be in setup.c
 * instead???
 *
 * Modified: Dean Collins Wed Nov 16 12:29:57 PST 1994
 * Added Priority field for WriteProblem().
 *
 * Modified: Dean Collins Sun Jan 15 01:58:59 PST 1995
 * Moved several #defines here from xpts for FormatProblem().
 *
 * Modified: Dean Collins Sun Mar  5 19:27:13 PST 1995
 * Added i/o stream to TraverseList's argument list.
 *
 * Modified: Dean Collins Wed Mar  8 18:46:53 PST 1995
 * Added FormatProblemHTML().
 *
 * Modified: Dean Collins Sat May 27 19:58:09 PDT 1995
 * Added ReportAgainPRID() and ReadProblemPRID().
 */

/*
 * Copyright (c) 1995,1994,1993 Dean Collins.
 * Copyright (c) 1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of the University of Idaho
 * Dean Collins and Luke Sheneman not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The University of Idaho, Luke Sheneman and Dean Collins
 * make no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO, LUKE SHENEMAN, AND DEAN COLLINS  DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * LUKE SHENEMAN OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include "pts.h"


/*Following define modified 3/23/93, Dean Collins */
/* Removed 3/13/94.  Dean Collins.  Having a default doesn't make sense.
 * The person building PTS needs to define this before building.
 *
#ifndef SYSOPGID
#define SYSOPGID 25 
#endif
 *
 */

#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif

/* SUMMARY_DESC_LEN is the maximum length of the summary description strings
 * (like "  (SOLVED)", etc.)  Check in summaries.c, function FormatSummaries(),
 * to ensure this integer is suficient.
 */
#define SUMMARY_DESC_LEN 25

#ifndef MAXMAILADDR
#define MAXMAILADDR 128		/* The maximum length of an e-mail address */
#endif /*MAXMAILADDR*/

#ifndef MAXBRANCHES
#define MAXBRANCHES 512		/* The maximum number of leaves in the 
				   problem tree
				 */
#endif /*MAXBRANCHES*/

#define MAXSUMMARIES 512	/* This is not a limit, but a throwback to 
					an old debugging function in 
					tester.c 
				*/

#define ABS_TYPE  0
#define INC_TYPE  1
#define PREV_TYPE 2

#define ROOTSTR "ROOT"

#define PTS_UMASK 022

#define TEMPLATE "/tmp/ptstmpXXXXXX"

/*Following defined modified 3/12/94, Dean Collins.  Now using sendmail. */
#ifndef MAILER
#define MAILER	"/usr/lib/sendmail"
#endif
/* The next may need to be changed if you're not using sendmail to "-s". DC
 * Modified 3/12/94 DC.  Use "mailer_opts:" in config file to change.
 */
#ifndef MAILER_OPTS
#define MAILER_OPTS "-t"
#endif
 /* Modified 3/12/94 DC.  ' characters no longer required or desired. */
#ifndef REOPEN_SUBJ
#define REOPEN_SUBJ 	"PTS Reopen Request"
#endif
#ifndef SOLVED_SUBJ
#define SOLVED_SUBJ	"PTS Solved Notice"
#endif

#ifndef PRINTER
#define PRINTER		"/usr/bin/lp"
#endif
#ifndef PRINTER_OPTS
#define PRINTER_OPTS 	""
#endif

/************ FormatProblem() defines **************************************/
/* These are strings used by the problem viewer to seperate the
 * various parts of the problem log.
 */
#ifndef PROBLEM_STR
#define PROBLEM_STR "PROBLEM DESCRIPTION:\n"
#endif

#ifndef REOPEN_REQ_STR
#define REOPEN_REQ_STR "REOPEN REQUEST REASON:\n"
#endif

#ifndef REOPEN_REQ_STR2
#define REOPEN_REQ_STR2 "\n\nORIGINAL PROBLEM LOG: \n" \
                        "---------------------------------------------------\n"
#endif

#ifndef LOG_ENTRY_STR
#define LOG_ENTRY_STR "\n\nLOG ENTRY:\t"
#endif

#ifndef SOLVED_ENTRY_STR
#define SOLVED_ENTRY_STR "\n\nPROBLEM SOLUTION:\t"
#endif

#ifndef REOPENED_ENTRY_STR
#define REOPENED_ENTRY_STR "\n\nPROBLEM REOPENED:\t"
#endif


/* NAMELEN is the maximum number of characters in a reporter record's
 * account field that will be displayed when viewing a problem. 
 * The account name may be longer, but extra characters will be ignored.
 */
#ifndef NAMELEN
#define NAMELEN 20
#endif

/* NODELEN is the maximum number of characters in a reporter record's
 * node field that will be displayed when viewing a problem.
 * The account name may be longer, but extra characters will be ignored.
 */
#ifndef NODELEN
#define NODELEN 20
#endif



struct Full_path
{
	char path[DBPATHLEN];
	struct Full_path *next;
};

typedef struct problemtree
{
	struct problemtree *subhead;
	struct problemtree *next;
	char fullpath[DBPATHLEN];
	char path[DBPATHLEN];
} ProblemTree;

typedef struct sum
{
	char summary[MAXSUMLEN];
	char prid[MAXPRID];
	char path[DBPATHLEN];
	int status;
	struct sum *next;
} Summary;


typedef struct stringlistrec	/* added 2/25/94 DC */
{
        char string[COMPLETEPATHLEN+1];
        struct stringlistrec *next;
} StringListRec;


typedef struct 
{
	int sysopflag;
	char *username;
	char *realname;
} UserInfo;


typedef struct mailinfo
{
        char useraddr[MAXMAILADDR];
        int days;
	StringListRec *pathlist ; /*Added 3/1/94 DC */
        struct mailinfo *next;
} MailInfo;


/* The command to print files will be stored here. DC 2/23/94 */
extern char PrinterCmd[COMPLETEPATHLEN] ;

/* The options for PrinterCmd used to print files will be stored here.
 * DC 2/23/94 
 */
extern char PrinterOpts[COMPLETEPATHLEN] ;

/* The command to mail files will be stored here. DC 2/23/94 */
extern char Mailer[COMPLETEPATHLEN] ;

/* The command-line switches useded by Mailer will be stored here. 
 * Usually this is "-t" for sendmail, "-s" for other mail progs.
 * DC 2/24/94 
 */
extern char MailerOpts[COMPLETEPATHLEN] ;

/* If not NULL, this is a NULL-terminated list of sysops.
 * If empty (NULL) use GID of user. 
 **/
extern StringListRec *SysopList ;



/*********************** Prototypes for setup.c *****************************/

int Setup(UserInfo *, ProblemTree **);
void BuildTree(ProblemTree **, struct Full_path *);
void BreakUpPath(char *,char *parts[MAXBRANCHES]);
void BreakUpPath2(char *,char parts[MAXBRANCHES][DBPATHLEN]);
void BuildTreePath(ProblemTree **, char parts[MAXBRANCHES][DBPATHLEN], int);
ProblemTree *FindBranch(ProblemTree *, char *);
void AddNode(struct Full_path *, char *);
void TraverseLeaves(ProblemTree *, struct Full_path *);
void TraverseTree(ProblemTree *, struct Full_path *);




/********************* Prototypes for problems.c ***************************/

int FormatProblemTypes(ProblemTree *, char *, int, int, char *types[]);
problem_record *ReadProblem(ProblemTree *, char *, int, Summary *);
problem_record *ReadProblemPRID(char *path, char *prid);
int LockProblem(char *, problem_record *);
int UnlockProblem(char *, problem_record *);
int SolveProblem(ProblemTree *, char *, problem_record *, char *, UserInfo *);
problem_record *ReopenProblem(ProblemTree *, char *, problem_record *, char *);
int ReopenRequest(char *, problem_record *, char *, UserInfo *);
int DenyReopen(ProblemTree *, char *, problem_record *, UserInfo *, char *);
problem_record *ReportAgain(char *path, UserInfo *, problem_record *);
int ReportAgainPRID(char *path, char *prid, char *email, char *hostname) ;
int DeleteProblem(ProblemTree *, char *, problem_record *);
int MoveProblem(ProblemTree *, char *, problem_record *, char *);
int LinkProblem(ProblemTree *, char *, problem_record *, char *);
int PrintProblem(ProblemTree *, char *, problem_record *);
int WriteProblem(ProblemTree *, char *, UserInfo *, char *, char *, char *, char);
int AppendProblem(ProblemTree *, char *, problem_record *, UserInfo *, char *);
int IsSysop(UserInfo *);
void CopyProblemRecord(problem_record *,problem_record *);
char *FixTime(char *);
int IsReopened(char *,problem_record *);
void FreeProblemRecord(problem_record *);






/********************* Prototypes for summaries.c ***************************/

Summary *ReadUnsolvedSummaries(ProblemTree *, char ***);
Summary *ReadSummaries(ProblemTree *, char *, char ***);
Summary *FormatSummaries(Summary *, Summary *, char ***);
Summary *FormatUnsolvedSummaries(Summary *, char ***);
void printsummaries(Summary *);
int CompPrid(char *, char *);
Summary *AddSummary(Summary *, problem_record *, char *);
problem_record *ReadUnsolved(ProblemTree *,char *,Summary *,int);
int FreeSummaries(Summary *);
char *FixPath(char *);
Summary *SortSummaries(Summary *);
Summary *AddSortedSummary(Summary *,Summary *);
void DummyTraverseSummaries(Summary *);
void FreeList(char **);





/********************** Prototypes for subtree.c ****************************/

void FreeParts(char *parts[MAXBRANCHES]);
ProblemTree *SubTree(ProblemTree *, char *);
int IsLeaf(ProblemTree *tree, char *path);
void TraverseList(FILE *, struct Full_path *);



/********************** Prototypes for tester.c *****************************/

void PrintUserInfo(UserInfo *);
int P_code(int, struct Full_path **);
void PrintParts(char parts[MAXBRANCHES][DBPATHLEN]);
void PrintUnsolvedSummaries(char unsummaries[MAXSUMMARIES][MAXSUMLEN]);
void TraverseSummaries(Summary *);
void printsummary(Summary *);

/********************** Prototypes for formatprob.c *************************/
char * FormatProblem(problem_record *, char *) ;
