.TH xpts 1 "22 July 1995" "Zombie Software" "PTS version 1.1a2"
.SH NAME
xpts - Problem Tracking System database interface for X11
.SH SYNOPSIS
xpts [ -noquit ] [-toolkit options...]
.SH OPTIONS
.IP -noquit 10
Start xpts in "noquit" mode.
In this case xpts starts as a small bitmap rather than at the main menu.
Pressing the mouse button on the bitmap brings up the main menu.
Pressing the "Quit" button in the main menu returns to the bitmap.
It is like an icon; however, it's appearance and behavior will be the same
regardless of what window manager the user has chosen (ctwm, mwm, etc.),
thus simplifying problem reporting in a heterogeneous environment.
.sp 1
.IP "-toolkit options" 10
.I Xpts
accepts all of the standard X Toolkit command line options.
.SH DESCRIPTION
.I PTS
is a database tool which is used to improve communication 
between system users and support personnel about problems encountered
with the system.
.I Xpts
is an X Window System application used to access 
the PTS database in an X environment. 
.PP
In a nutshell:  Users report problems with 
.I Xpts,
support personnel log their activities on solving each problem,
and users are notified when their problems are solved.
.PP
Remember:  There is no problem that can't be solved by
a suitable application of high explosives...
.SH GETTING STARTED
Hopefully, the
.I xpts
user-interface is rather intuitive and doesn't require much discussion.
(Well, that's our hope, anyway. :-)
Users familiar with using other X applications should have no significant
problems using
.I xpts.
All windows have a similar layout, with titles on top, buttons on bottom,
and "something else" in the middle.  "Something else" may be a list,
text, a dialog box, or "something else".
(Note: Always use "single-clicks" rather than "double-clicks" when
using the mouse.)
.SH BASIC OPERATIONS
.SH Reporting a Problem
.IP "Step 1:" 10
Select "Report a Problem" from the
.I xpts
Main Menu.
.IP "Step 2:" 10
Navigate through the problem tree until you find the appropriate problem type
for your problem.  Note that you can only report problems into leaves
of the tree.
.IP "Step 3:" 10
You should now visually scan through the problems for that
problem type, looking for ones that may be the
same as the one you are about to report.  View any that look promising.
.IP "Step 4:" 10
If you find one and it
is marked as "UNSOLVED", proceed to the section of this document
called "Reporting a Problem Again".  If you find one and it is
marked as "SOLVED", proceed to the section called "Reopening a Problem".
.IP "Step 5:" 10
At this point the button "New Problem" should be visible.  Select it.
(If you were viewing a problem as mentioned in step 3 you need to
quit the problem viewer and go back to the summaries screen first.)
.IP "Step 6:" 10
Fill in the fields as appropriate.  The Summary should be a
short, one-line summary of your problem.  Be as descriptive as possible.
Avoid generic summaries such as "Help!" or "I found a bug".
The Node is the name of the machine the problem occured on.
It defaults to the name of the current host, but can be changed.
Finally, enter a full problem description.  BE AS DESCRIPTIVE
AS POSSIBLE.  Include the full text of all associated error message,
if any.
.IP "NOTE:" 10
Once your problem is entered into the database the support staff
will begin working on it.  They will log their progress on solving
your problem, which you can view at any time.  Once the problem
is solved you will receive the complete problem log, including
the final solution, via e-mail.  This is provided both to notify
you that your problem is solved and to inform you of the 
final solution.  If you find that your problem is still not fixed,
despite this notification, you can request that the problem
be reopened (see "Reopening Problems" below.)

.SH Reporting a Problem Again

When viewing an unsolved problem you can specify that you would
like to be notified when the problem is solved.  You should do
this when you start to report a problem and find someone else
has already reported it.  You might also do it if you would like
to have an interesting problem e-mailed to you when it is solved.
When you report a problem again you will be listed in the list
of reporters for the problem, and the machine you are running
.I xpts
on will be listed under the Node field, along with the current
date and time.  Note:  There is no way to specify another node when
you choose "Report Again" like you can when reporting a new problem.

.SH Reopening a Problem

When viewing a solved problem you can request that the problem be
reopened by using the "Request Reopen" button.  A support staff
person will review your request.  If the problem does appear to
need to be reopened they will do so, otherwise they will send
you mail explaining why they did not reopen it.  Usually reopen
requests are not denied, but that is at the discression of your
local support staff.

.SH Printing a Problem
When viewing a problem you can print the problem 
using the "Print Problem" button.

.SH SYSOP OPERATIONS
.I Note:
Most users of
.I xpts
will not have access to these features.
Only users who are considered "sysops" will be allowed to
perform these actions.  See the INSTALL document for information
on how to specify which group is the "sysop" group.
See the 
.I pts.cf(8)
manpage for information on including specific users in the sysop list.

.SH Editing a Problem

When viewing an unsolved problem, sysops can add their own comments 
to the problem log by using the "Edit" button.  When done editing,
sysops can either "Save" or "Solve" the problem.
Save just adds the new comments to the log.  Solve adds the 
comments and marks the problem as solved.  If the problem is
solved in this fashion the problem reporter(s) will be e-mailed
the complete problem log, along with the sysop's solution.

Only one sysop can edit a specific problem at a time.

.SH Solving a Problem

See the description above on "Editing a Problem."  Just choose
the "Solve" button instead of the "Save" button.

.SH Moving a Problem

When viewing a problem sysops can move the problem into another
leaf of the problem tree using the "Move Problem" button.
A pop-up will prompt the sysop for the new problem type name.
Moving problems around tends to clutter up the database, so
problems should only be moved when necessary.

.SH Deleting a Problem

When viewing a problem sysops can delete the problem 
using the "Delete Problem" button.  Once deleted, the problem
is gone forever.

.SH Accepting or Denying Reopen Requests

When viewing a reopen request sysops can accept or deny the request
using the appropriate button.  Accepted requests will cause the
corresponding problem to be marked as "UNSOLVED", and the reopen
request will be appended to the problem log.  If you deny a request
you will be prompted to enter an explanation of why the reopen
request was denied, which will be e-mailed to the reporter of the
reopen request.  In either case the reopen request itself will
be removed from the database.


.SH ADVANCED OPERATIONS

.I Note:
Most users of
.I xpts
will not have access to these features.
As mentioned above, see the INSTALL document and
.I pts.cf(8)
for more information about specifying who are sysops.

.SH Adding a Problem Type After Installation (sysops only)
.IP "Step 1:" 10
Edit pts.cf and add the problem type (what could be simpler!)
.IP "NOTE:" 10
Your additions
.I won't
affect any already-running xpts applications.

.SH Deleting a Problem Type After Installation (sysops only)
.sp 1
.IP "Step 1:" 10
Use Database Maintenance mode to move or delete all problems
in the leaf.
.IP "Step 2:" 10
Edit pts.cf and remove the problem type.
.IP "NOTE:" 10
DON'T Delete the directory for the leaf from the database.
.SH Renaming a Problem Type
.IP "Step 1:" 10
Add the new problem type to the pts.cf file.
.IP "Step 2:" 10
Move all problems from the old leaf to the new leaf
using DB Maintenance mode.
.IP "Step 3:" 10
Remove the old problems, again, using DB Maintenance mode.
.IP "Step 4:" 10
Remove the old problem type from the
.I pts.cf
file.

.\"The following should work fine, but was removed from the manpage
.\"since it is confusing and could cause trouble if the user is
.\"inexperienced or not careful.
.\".SH Adding Linked-Types
.\".nf
.\"    1.  Add the softlink to the database manually
.\"    2.	Add the new problem type to pts.cf as if it
.\"	was a real directory.
.\"    3.	Make sure the directory for the type you're linking to exists
.\"	before making the link.
.\".fi
.SH X CUSTOMIZATION
.I Xpts
uses many X resources that you may wish to customize.
These resources specify what fonts
.I xpts
uses, as well as what colors.  They also are used to specify other 
.I xpts
attributes.  Some users who do not have the full font distribution
or the color database that comes with X11R4 or X11R5 may have to tweak the
colors and/or fonts.  (Complain to your vendor!)  Users with small
screens may need to change the window sizes and fonts.
.PP
To make system-wide customizations that will affect all 
.I xpts
users, edit the application defaults file,
.I Xpts,
usually located in
.I /usr/lib/X11/app-defaults.
.PP
To make customizations that will be used every time you run
.I xpts,
you may be able to override the default resource values 
using
.I .Xresources
or
.I .Xdefaults
in your home directory.  Consult your local documentation for 
more information on customizing X applications.
.PP
Finally, you can override default resources values for a single
invocation of
.I xpts
with the 
.I -xrm
X Toolkit command-line option.  For example, to override the default
font for most screens, you might enter:
.sp
.ti 5
xpts -xrm 'Xpts*font:	-*-lucida-bold-r-normal-sans-12-*'
.sp
.SH Fonts
Here are the default font resources used by 
.I xpts:
.ta 0.5i
.sp 1
.nf
	The font used for most screens:
.fi
.br
.ta 2.5i
Xpts*font:		-*-lucida-bold-r-normal-sans-14-*
.br
.ta 0.5i
.sp 1
.nf
	The fonts used for help lines:
.fi
.br
.ta 2.5i
Xpts*helpLine.font:	-*-lucida-bold-i-normal-sans-12-*
.br
Xpts*helpLine2.font:	-*-lucida-bold-i-normal-sans-12-*
.br
Xpts*helpLine3.font:	-*-lucida-bold-i-normal-sans-12-*
.br
Xpts*helpLine4.font:	-*-lucida-bold-i-normal-sans-12-*
.br
.ta 0.5i
.sp 1
.nf
	The font used for text editor and viewer windows:
.fi
.br
.ta 2.5i
Xpts*AsciiSink*font:	-*-lucidatypewriter-bold-r-normal-sans-14-*
.ta 0.5i
.sp 1
	The font used for the second help line
.br
	in the problem entry window:
.br
.ta 2.5i
Xpts*probEntry.panes.helpLine2.font:	-*-lucida-bold-r-normal-sans-14-*
.ta 0.5i
.sp 1
The main thing to keep in mind is that "Xpts*AsciiSink*font" should
be a 
.I non-proportional
font.
.SH Colors
Here are the default color resources used by 
.I xpts:
.sp 1
.ta 0.5i
.nf
	The colors used for most screens:
.fi
.br
.ta 4i
Xpts*background:			seashell
.br
Xpts*foreground:			black
.br
Xpts*borderColor:			black
.br
Xpts*internalBorderColor:		black
.br
.sp 1
.ta 0.5i
.nf
	The colors used for error popups:
.fi
.br
.ta 4i
Xpts*error*background:			red
.br
Xpts*error*foreground:			white
.br
Xpts*error*borderColor:			white
.br
Xpts*error*internalBorderColor:		white
.br
.sp 1
.ta 0.5i
.nf
	The colors used for warning popups:
.fi
.br
.ta 4i
Xpts*warning*background:		LightGoldenrod1
.br
Xpts*warning*foreground:		black
.br
Xpts*warning*borderColor:		black
.br
Xpts*warning*internalBorderColor:	black
.br
.sp 1
.ta 0.5i
.nf
	The colors used for signal error popups:
.fi
.br
.ta 4i
Xpts*signalError*background:		red
.br
Xpts*signalError*foreground:		white
.br
Xpts*signalError*borderColor:		white
.br
Xpts*signalError*internalBorderColor:	white
.br
.sp 1
.ta 0.5i
.nf
	The colors used for signal warning popups:
.fi
.br
.ta 4i
Xpts*signalWarning*background:		red
.br
Xpts*signalWarning*foreground:		white
.br
Xpts*signalWarning*borderColor:		white
.br
Xpts*signalWarning*internalBorderColor:	white
.br
.sp 1
.ta 0.5i
.nf
	The colors used for important notice popups:
.fi
.br
.ta 4i
Xpts*notice*background:			LightGoldenrod1
.br
Xpts*notice*foreground:			black
.br
Xpts*notice*borderColor:		black
.br
Xpts*notice*internalBorderColor:	black
.sp 1
If you're setting 
.I xpts
up in a mixed environment of color and monochrome displays
be sure that whatever colors you choose will display reasonably
in monochrome.
.SH Window Dimensions
.nf
Here are the default window dimension resources used by xpts:
.fi
.sp 1
Xpts*sleepPopup.geometry:		-162+15
.br
Xpts*mainMenu.geometry:			+10+10
.br
Xpts*pickProblem.geometry:		450x225+80+80
.br
Xpts*probViewer.geometry:		800x700+120+15
.br
Xpts*movePopup.geometry:		500x90+150+150
.br
Xpts*probEntry.geometry:		700x550+120+120
.br
Xpts*unsolvedPopup.geometry:		900x400+80+80
.br
Xpts*sysopMenu.geometry:		+50+50
.br
Xpts*motdPopup.geometry:		735x500+80+80
.br
Xpts*helpPopup.geometry:		735x500+80+80
.br
Xpts*infoPopup.geometry:		675x420+80+80
.br
Xpts*error.geometry:			675x300
.br
Xpts*warning.geometry:			675x300+80+80
.br
Xpts*signalError.geometry:		750x300+80+80
.br
Xpts*signalWarning.geometry:		750x300+80+80
.br
Xpts*notice.geometry:			700x300+80+80
.sp 1
.ta 0.5i

.SH Other Resources
.sp 1
.nf
	The bitmap image display when xpts is in sleep-mode:
.fi
.ta 4i
Xpts*sleepPopup.button.bitmap:	xpts.xbm
.ta 0.5i
.sp 1
.nf
	The help file displayed by clicking on
	the "Help" button in the Main Menu.
.fi
.ta 4i
Xpts*helpPopup.panes.text*string:	/usr/lib/X11/xpts.help
.ta 0.5i
.sp 1
.nf
	The help file displayed by clicking on
	the "Help" button in the Sysop Menu.
.fi
.ta 4i
Xpts*sysopMenu.helpPopup.panes.text*string:	/usr/lib/X11/xpts_sysop.help
.ta 0.5i
.sp 1
.nf
	
	Cause Xpts to use word-wrapping in it's
	editor windows:
.fi
.ta 4i
Xpts*motdPopup.panes.text*wrap:                 word
Xpts*motdPopup.panes.text*scrollHorizontal:     never
Xpts*probEntry.panes.text*wrap:                 word
Xpts*probEntry.panes.text*scrollHorizontal:     never
.ta 0.5i

.SH MORE INFORMATION
.I xpts
includes a very simple on-line help system.  "Help" buttons are
present for the Main Menu and the Sysop Menu.
.SH FILES
/usr/local/pts/lib --
.I  PTS
library files.
.br
/usr/local/pts/lib/pts.cf --
.I  PTS
configuration file.
.br
/usr/local/pts/lib/db --
.I  PTS
database.
.br
/usr/lib/X11/xpts.help -- On-line help file for 
.I xpts.
.br
/usr/lib/X11/xpts_sysop.help -- On-line help file for the sysop menu.
.br
/usr/lib/X11/app-defaults/Xpts -- X Application Defaults file.
.SH SEE ALSO
pts(1), ptsager(1M), pts.cf(8), zdbm(3), newprob(1).
.SH AUTHORS
The Problem Tracking System was originally designed by
.I Zombie Software
at the University of Idaho.
The X user-interface was designed and implemented by Dean Collins.
The database library was designed and implemented by Chris Hyde.
The high-level database interface was designed and implemented by
Luke Sheneman.
See
.I pts(1)
for more information.
.sp 1
.SH COPYRIGHT
Copyright (c) 1995,1994,1993,1992 Dean Collins and Chris Hyde.
.br
Copyright (c) 1992 Luke Sheneman, Brian Goff, and John Hunter.
.br
Copyright (c) 1992 University of Idaho, Moscow, Idaho.

