/* ptsager.c -- The Problem Tracking System problem-ager/auto-mailer.
 * Authors: Brian Goff & Dean Collins
 *
 * Modified: Sat Mar 27 15:20:27 PST 1993
 * 
 * Modified: Dean Collins Thu Feb 24 10:37:15 1994
 * Removed mutant use of ../xpts/util.c (since FixStr, StripLeading &
 * StripTrailing were moved to neb_cld, plus they're not even used anymore).
 * Changed MAIL_ADM_COMMAND to use Mailer & MAIL_ADM_OPTS.
 * An undocumented #define had to be modified for ptsager to work on
 * systems that used a mailer other than /usr/ucb/Mail.  It now
 * uses the mailprog: listed in the config file, or the default MAILPROG.
 * Options still need to be defined in MAIL_ADM_OPTS, but that can be
 * changed in the Imakefile.
 *
 * Modified: Dean Collins Sat Mar 12 18:21:03 1994
 * Removed MailAdm() and replaced with SendMail() call.  Removed
 * MAIL_ADM_OPTS.  Added MAIL_ADM_SUBJ.  Adjusted for renaming
 * of MailInfo.username as MailInfo.useraddr.
 */

/* Copyright 1994 Dean Collins.
 * Copyright 1993 Brian Goff, Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins nor the name of Brian Goff
 * be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission from both parties.
 * Neither The University of Idaho nor Dean Collins nor Brian Goff make
 * any representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE UNIVERSITY OF IDAHO, DEAN COLLINS AND BRIAN GOFF DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE
 * UNIVERSITY OF IDAHO OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */
#include <sys/types.h>		/* Standard types header file */
#include <sys/time.h>		/* System time header file */
#include <time.h>               /* time.h - ANSI C, DATE and TIME header file.*/
#include <limits.h>		/* Sizes, limits, etc. */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
#include "cgetopts.h"

#define DAYLEN  3
#define YEARLEN 4

/* This may be necessary on SunOS and HP-UX */
#ifndef ARG_MAX
#ifdef _POSIX_ARG_MAX
#define ARG_MAX _POSIX_ARG_MAX
#endif
#endif

/* This may be necessary on SunOS and HP-UX */
#ifndef FILENAME_MAX
#ifdef _POSIX_PATH_MAX
#define FILENAME_MAX  _POSIX_PATH_MAX
#endif
#endif

typedef struct FILTER_PARMS_T
{
    int  status;
    char *reporter_id;
    char *owner;
    char *path;
    int  age;
    MailInfo *p;
} filter_parms_t;
typedef filter_parms_t *filter_parms_ptr_t;

int CurYear, CurDay ;		/* current year and day of year */

/* FUNCTION PROTOTYPES */
int main(int argc, char *argv[]) ;
void  print_problem_tree(ProblemTree *ProbTree, filter_parms_ptr_t filter);
void print_problem_fp(problem_record *problem, char* path, FILE* fp);
void print_problem(Summary *summary, problem_record *res);
int filter_problem(Summary *summary, problem_record *res, filter_parms_ptr_t filter);
void GrabSysDate(int *yr, int *day);
void ParseDate(char *prid, int *yr, int *day);
int DaysOld(int ProbYear, int ProbDay, int CurYear, int CurDay);
int YearLength(int year);

int main(int argc, char *argv[])
{

   char **UnsolvedList = NULL ;		/* The list of unsolved problems */
   Summary *CloudUnSummaries = NULL ;	/* A ptr. to the unsolved problems
					 * linked list (used by neb_cld).
					 */
   Summary *s = NULL ;			/* The list of problem summaries */
   ProblemTree *ProbTree ;		/* The problem types tree */
   UserInfo UserInfoRec ;		/* Information about the user */
   problem_record *ProblemRecord ;	/* A full problem record */
   MailInfo *MailList=NULL ;		/* A list of people to send mail to. */
   int NumAdmRecs=0 ;			/* Counter of # of MailSysAdm records*/

          /* Minor */
   MailInfo *p=NULL ;			/* A temporary mail list pointer */
   int age ;				/* The age of a problem */
   int i ;				/* Misc counter. */
   StringListRec *plist ;
   filter_parms_t filter;

   int opt;
   cget_opts_t getopts;
   static const char* flag_opts = "u:r:a:s:p:";
   
printf("STARTING PTSPRT...\n") ;
   
   filter.status = 0;
   filter.reporter_id =  NULL;
   filter.owner =  NULL;
   filter.path =  NULL;
   filter.age = 0;

   argv++;
   argc--;
   
   cget_opts_init(&getopts, argc, argv, '-');
   while ((opt = cget_opts_next(&getopts, flag_opts)) != EOF)
   {
       switch(opt)
       {
	 case 'u':
	   filter.owner =  getopts.arg_str;
	   break;
	 case 'r':
	   filter.reporter_id =  getopts.arg_str;
	   break;
	 case 'a':
	   filter.age =  atoi(getopts.arg_str);
	   break;
	 case 's':
	   if (strcmp(getopts.arg_str, "solved") ==  0)
	   {
	       filter.status =  SOLVED;
	   }
	   else if (strcmp(getopts.arg_str, "unsolved") ==  0)
	   {
	       filter.status =  UNSOLVED;
	   }
	   else if (strcmp(getopts.arg_str, "reopened") ==  0)
	   {
	       filter.status =  REOPENED;
	   }
	   else
	   {
	       fprintf(stderr, "\nunknown status %s\n", getopts.arg_str);
	   }
	   break;
	 case 'p':
	     filter.path =  getopts.arg_str;
	   break;
	 default:
	   fprintf(stderr, "\nunknown option %c\n",  opt);
	   fprintf(stderr, "options are\n");
	   fprintf(stderr, "-r reporter_id\n");
	   fprintf(stderr, "-u user\n");
	   fprintf(stderr, "-p path\n");
	   fprintf(stderr, "-a age\n");
	   fprintf(stderr, "-s status\n");
	   exit(1);
	   break;
       }
   }
   
   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  
       fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
       exit(1);
   }
   

   config_mail(&MailList);
   p =  MailList;
   if (filter.owner !=  NULL)
   {
       
       while (p != NULL && strcmp(p->useraddr, filter.owner)!= 0)
       {
	   p =  p->next;
       }
       if (p == NULL)
       { 
	   fprintf(stderr, "owner %s not found, assuming no owner\n", filter.owner);
       }
   }
   else
   {
       p =  NULL;
   }
   filter.p =  p;
   
   GrabSysDate(&CurYear, &CurDay);
   print_problem_tree(ProbTree, &filter);
   return(0);
   
}  /*-------------------------- End of main() -----------------------------*/

void  print_problem_tree(ProblemTree *ProbTree, filter_parms_ptr_t filter)
{
    char **summaries;
    Summary* summary;
    int i;
    int j;
    Summary* temp;
    char newpath[DBPATHLEN];
    problem_record *res;


    if (ProbTree != NULL)
    {
	if (ProbTree->subhead ==  NULL)
	{
	    summary =  ReadSummaries(ProbTree,ProbTree->fullpath,&summaries);
	    if (summary != NULL)
	    {
	        printf("\nproblems from %s\n\n", ProbTree->fullpath);
	    }
	    strcpy(newpath,FixPath(ProbTree->fullpath));
	    for (i = 0, temp = summary; temp !=  NULL; temp = temp->next, i++)
	    {
		free(summaries[i]);
		res=get_problem(newpath,temp->prid,
				PARTICULAR,NULL,LINKS,FULLRECORD);
		if (res !=  NULL
		    && !filter_problem(temp, res, filter))
		{
		    /* print_problem(temp, res); */
		    print_problem_fp(res, newpath, stdout);
		}
	    }
	    free(summaries);	
	    FreeSummaries(summary);
	    
	}
	print_problem_tree(ProbTree->subhead, filter);
	print_problem_tree(ProbTree->next, filter);
	
    }
} 

void print_problem_fp(problem_record *problem, char* path, FILE* fp)
{
    int i,j,buflen;
    reporter_record *reporter;
    int maxname=MAXANAMELEN-8;
    int numrep=0 ; 		/* Number of reporters in reporter list */

    fprintf(fp,"PROBLEM ID:\t%s\n", problem->prid);
    fprintf(fp,"PROBLEM PATH:\t%s\n", path);
    fprintf(fp,"STATUS:\t\t");
    switch(problem->status)
    {
      case UNSOLVED:
	fprintf(fp,"Unsolved\n\n");
	break;
      case SOLVED:
	fprintf(fp,"Solved\n\n");
	break;
      case REOPENED:
	fprintf(fp,"Reopen Request\n\n");
	break;
      default:
	break;
    }
    
    fprintf(fp,"SUMMARY:\n");
    fprintf(fp,"%s\n\n",problem->short_description);
    
    fprintf(fp,"%-*s%-*s%s\n",maxname,"REPORTER",FNAMELEN,"NODE","DATE/TIME");
    fprintf(fp,"%-*s%-*s%s\n",maxname,"--------",FNAMELEN,"----","---------");
    
    
    reporter=problem->reporter_list;
    numrep=problem->num_rep ;		/*DC 2/24/94*/
    if (reporter == NULL)			/* " */
    {
	reporter=problem->old_reporter_list;	/* " */
	numrep=problem->num_old_rep ;	/* " */
    }					/* " */
    if (reporter)
    {
	for(i=0;i<numrep;++i)
	{
	    fprintf(fp,"%s",(reporter[i]).account_name);
	    buflen=strlen((reporter[i]).account_name);
	    for(j=buflen;j<maxname;++j)
		fprintf(fp," ");
	    
	    fprintf(fp,"%s",(reporter[i]).node_name);
	    buflen=strlen((reporter[i]).node_name);
	    for(j=buflen;j<FNAMELEN;++j)
		fprintf(fp," ");

	    fprintf(fp,"%s",(reporter[i]).date_time);	
	    
	    fprintf(fp,"\n");
	}
    }
    fprintf(fp,"\n");
    
    fprintf(fp,"PROBLEM DESCRIPTION:\n");
    fprintf(fp,"%s",problem->log_file);
    fprintf(fp,"\n"); 
}

void print_problem(Summary *summary, problem_record *res)
{
    int j;
    printf("\n");
    printf("\tProblem->        %s\n", summary->summary);
    printf("\tProblem Id->     %s\n", summary->prid);
    printf("\tProblem Path->   %s\n", summary->path);
    printf("\tProblem Status-> %d\n", summary->status);

    printf("\nProblem Description\n\n%s\n\n", res->log_file);
    /*
      res->prid, res->status, 
      res->short_description, res->num_rep, 
      res->old_reporter_list, res->log_file);
    */
    printf("\nproblem reporters\n");
    for (j = 0; j<res->num_rep; j++)
    {
	printf("\t\t%s %s %s\n", 
	       res->reporter_list[j].account_name,
	       res->reporter_list[j].node_name,
	       res->reporter_list[j].date_time);
    }
    for (j = 0; j<res->num_old_rep; j++)
    {
	printf("\t\t%s %s %s\n", 
	       res->old_reporter_list[j].account_name,
	       res->old_reporter_list[j].node_name,
	       res->old_reporter_list[j].date_time);
    }
    printf("\n");
}

int filter_problem(Summary *summary, problem_record *res, filter_parms_ptr_t filter)
{
    int ret =  0; 
    int ProbYear, ProbDay ;		/* year and day of year a problem */
    int age;
    int i;
    reporter_record *reporter;
    int numrep;
    
    
    if (summary ==  NULL || res ==  NULL || filter == NULL)
    {
        return(ret);
	
    }

    if (filter->status != 0
	&& filter->status !=  res->status)
    {
	ret =  1;
    }
    else
    {
        ParseDate(summary->prid,&ProbYear,&ProbDay) ;
	age = DaysOld(ProbYear,ProbDay,CurYear,CurDay) ;
	if (age < filter->age)
	{
	    ret =  1;
	}
	else
	{
	    if (filter->path !=  NULL
		&& strncmp(filter->path, summary->path, strlen(filter->path))
		    !=  0)
	    {
		ret =  1;
	    }
	    else
	    {
		
		if (filter->p !=  NULL
		    && filter->p->pathlist != NULL 
                    && InStringList(summary->path,
				    filter->p->pathlist,PREFIXCMP) == 0)
		{
		    ret =  1;
		}
		else
		{
		    reporter=res->reporter_list;
		    numrep=res->num_rep ;		/*DC 2/24/94*/
		    if (reporter == NULL)			/* " */
		    {
			reporter=res->old_reporter_list;	/* " */
			numrep=res->num_old_rep ;	/* " */
		    }					/* " */
		    if (reporter !=  NULL && filter->reporter_id!= NULL)
		    {
			i =  0;
			while (  i<numrep
			       && strcmp(reporter[i].account_name,
			                          filter->reporter_id) != 0)
			{
			    i++;
			}
			if (i ==   numrep)
			{
			    ret =  1;
			}
		    }
		}
		
	    }
	}
    }
    return(ret);     
}



void GrabSysDate(int *yr, int *day)
{
   struct timeval curdate;        /* current system date */
   struct timezone tz;		  /* current time zone */
   struct tm *localdate ;

   gettimeofday(&curdate, &tz) ;
   localdate=localtime(&(curdate.tv_sec)) ;
   *yr = 1900 + localdate->tm_year ;
   *day = localdate->tm_yday + 1 ; 
}  /*----------------------- End of GrabSysDate() -----------------------*/

void ParseDate(char *prid, int *yr, int *day)      
{

   char daystr[MAXPRID] ;
   char yrstr[MAXPRID] ;
   char *p ;

   strncpy(daystr,prid,DAYLEN) ;
   daystr[DAYLEN] = '\0' ;

   p = &(prid[DAYLEN]) ;
   strncpy(yrstr,p,YEARLEN) ;
   yrstr[YEARLEN] = '\0' ;

     /* Convert to integers and store in yr & day */
   *yr = atoi(yrstr) ;
   *day = atoi(daystr) ;

}  /*----------------------- End of ParseDate() --------------------------*/

int DaysOld(int ProbYear, int ProbDay, int CurYear, int CurDay)
{
   int delta;	
   switch(CurYear - ProbYear)
   {
      case 0:   delta = CurDay - ProbDay ;
                break ;

      case 1:   delta = YearLength(ProbYear) - ProbDay + CurDay ;
                break ;

      default:  delta = 0 ;
   }

   return(delta) ;

}  /*-------------------------- End of DaysOld() --------------------------*/


int YearLength(int year)   
{
    int length;
    
    if (year % 4) length = 365 ;
    else if (year % 400) length = 365 ;
    else length = 366 ;
    return (length) ;
}  /*----------------------- End of YearLength() --------------------------*/

/* End of ptsager.c */
