/* danger.c
 *
 * This program goes through the problem tree and blindly changes the edit
 * flags in the index enties to FALSE.  It DOES NOT check anything before
 * changing the flag, so BE CAREFULL!!!!!
 *
 */

/* danger2.c
 *
 * This program goes through the problem tree and checks the mrd field of each
 * problem index entry, if the field == DELETED rather than GONE, then it
 * changes the mrd field to GONE and writes the index back out.  While this
 * is not too dumb, it could still cause problems if used at the wrong time,
 * so BE CAREFULL!!!!
 *
 */

#include "danger.h"

FILE *locknload();
void remove_edit_locks();
void fix_deleted();

main(int argc, char *argv[])
{
 struct Full_path *tree_root;
 char emess[81];
 int choice;

 printf("Which DANGEROUS one (1 or 2)? ");
 gets(emess);
 choice=atoi(emess);

 if (config_tree(&tree_root)==ERROR)
 {
    perror("Error in config()");
    exit(errno);
 }

 switch (choice)
 {
    case 1:	remove_edit_locks(tree_root);
		break; /* end of switch 1 */

    case 2:	fix_deleted(tree_root);
		break; /* end of switch 2 */

    default:	printf("BAD choice %d - exiting.\n", choice);
		exit(1);
 } /* end switch */

} /* end danger.c */

FILE *locknload(char *path)
{
 char db_path[COMPLETEPATHLEN];
 char *cp;
 char emess[81];
 FILE *temp;

 cp=rindex(path, '/');
 if (cp==NULL)
    cp=path;
 else
    cp++;

 sprintf(db_path, "%s%s/%s.index", PTSROOT, path, cp);

 if ((temp=fopen(db_path, "r+"))==NULL)
 {
    sprintf(emess, "\n*****\n\tCould not open %s\n\t", db_path);
    perror(emess);
    return(NULL);
 }

 if (lock_file(temp)==FAIL)
 {
    fclose(temp);
    sprintf(emess, "\n***** Could not lock %s\n\t", db_path);
    perror(emess);
    return(NULL);
 }
 return(temp);
} /* end locknload() */

void remove_edit_locks(struct Full_path *tree_root)
{
 struct Full_path *node;
 index_record index;
 FILE *db_pointer;
 char *cp;
 char emess[81];

 for (node=tree_root; node->next!=NULL; node=node->next)
 {
    if ((db_pointer=locknload(node->path))==NULL)
    {
       continue;
    }
    printf("\n*****\n  Cleaning up %s%s index file now ", PTSROOT, node->path);
    while (fread(&index, sizeof(index_record), 1, db_pointer)==1)
    {
       printf("!");
       index.ef=FALSE;
       fseek(db_pointer, -(long)sizeof(index_record), SEEK_CUR);
       if (fwrite(&index, sizeof(index_record), 1, db_pointer)!=1)
          break;
       fseek(db_pointer, 0L, SEEK_CUR);
    } /* end while */

    if (ferror(db_pointer))
    {
       sprintf(emess, "Error reading or writting to %s index file");
       perror(emess);
    }
    printf("\n*****\n");
    unlock_file(db_pointer);
    fclose(db_pointer);
 } /* end for */
} /*end remove_edit_locks() */

void fix_deleted(struct Full_path *tree_root)
{
 struct Full_path *node;
 index_record index;
 FILE *db_pointer;
 char *cp;
 char emess[81];

 for (node=tree_root; node->next!=NULL; node=node->next)
 {
    if ((db_pointer=locknload(node->path))==NULL)
    {
       sprintf(emess, "Problem with locking and loading %s", node->path);
       continue;
    }
    printf("\n*****\n  Cleaning up %s%s index file now ", PTSROOT, node->path);
    while (fread(&index, sizeof(index_record), 1, db_pointer)==1)
    {
       printf("!");
       if (index.mrd==DELETED)
       {
	  index.mrd=GONE;
	  fseek(db_pointer, -(long)sizeof(index_record), SEEK_CUR);
          if (fwrite(&index, sizeof(index_record), 1, db_pointer)!=1)
	     break;
	  fseek(db_pointer, 0L, SEEK_CUR);
       } /* end if */
    } /* end while */
    if (ferror(db_pointer))
    {
       sprintf(emess, "Error reading or writting to %s index file");
       perror(emess);
    }
    printf("\n*****\n");
    unlock_file(db_pointer);
    fclose(db_pointer);
 } /* end for */
} /* end fix_deleted() */
