/*configtest.c -- Used to test the config file parser.
  Dean Collins
  Wed Feb 23 12:18:04 1994

  Usage: configtest [file [parsetype]]

Copyright (c) 1995,1994 Dean Collins

Permission to use, copy, modify, and distribute this software and its
documentation free of charge for any purpose is hereby granted without
fee, provided that the above copyright notices appear in all copies and
that both those copyright notices and this permission notice appear in
supporting documentation, and that the name of Dean Collins not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  Dean Collins
makes no representations about the suitability of this software for
any purpose.  It is provided "as is" without express or implied warranty.

DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
*/

#include <stdio.h>
#include "zdbm.h"
#include "cloud.h"
#include "config.h"

extern int debug ;
extern char ParserPath[] ;
extern char ParserName[] ;
extern int ParserDays ;
extern FILE *yyin ; /* From lex.yy.c */

/* The rest really aren't supposed to be accessed outside of config.yacc,
 * but are anyhow for testing purposes.
 */
extern int parsetype ;
extern struct Full_path *CfgTree ;


/*
______________________________________________________________________
main()

FUNCTION DESCRIPTION:
	This function is used to test the parser.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins			Date: 2/23/94
______________________________________________________________________
*/



int main(int   argc, 
	 char *argv[])

     /* Interface description:
         INPUT:
          argc		- command-line argument count
          argv		- command-line argument list
         OUTPUT:
          None.
         RETURN VALUE:
          int		- status
     */

{
     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
          /* NONE */


   /*------------------ Start of main() routine -------------------*/

   if (argc > 3)
   {  printf("wrong number of arguments.\n") ;
      fprintf(stderr,"Usage: %s [file [parsetype]]\n", argv[0]) ;
      exit(1) ;
   }
   printf("Beginning parse test...\n") ;
   if (argc == 2)
	ParseTest(PARSEMISC, argv[1]) ;
   else if (argc == 3)
        ParseTest(atoi(argv[2]), argv[1]) ;
   else ParseTest(PARSEMISC, NULL) ;

}  /*---------------------- End of main() -------------------------*/



int 
ParseTest(int type,
	  char *Fname)

     /* Interface description:
         INPUT:
          type 		- type of parse to perform (PARSEPATH, PARSEMAIL,...)
	  Fname		- filename of the config file to test, if not NULL.
         OUTPUT:
          None.
         RETURN VALUE:
          int		- status
     */
{

     /* Internal variables: */
          /* Major */
          /* NONE */
          /* Minor */
          /* NONE */

   /*------------------ Start of ParseTest() routine -------------------*/

	/* Open the configuration file for reading. */
   if (Fname != NULL)
        yyin = fopen(Fname, "r") ;
   else yyin = fopen(CONFIGFILE, "r") ;
   if (yyin == NULL)
   {   fprintf(stderr, "Error opening config file %s !\n", CONFIGFILE) ;
       return (-1) ;
   }

	/* Call the parser and have it build the tree. */
   parsetype=type;
   parse_error=0 ;
   if (debug) printf("Beginning NEW & IMPROVED config file parse...\n") ;

   yyparse() ;

   if (debug) printf("\nEnding NEW & IMPROVED config file parse...\n") ;

#ifdef DEBUG
          fprintf(stderr,"\n") ;
/*CLD*/   if (parsetype == PARSEPATH) TraverseList(stderr,CfgTree) ;
          fprintf(stderr,"\n") ;
#endif

	/* Close the configuration file. */
   fclose(yyin) ;

   return(parse_error) ;

}  /*---------------------- End of ParseTest() -------------------------*/

/* End of tester.c */
