%{
/* config.lex -- Tokenizer for the config file parser.
 * Dean Collins
 * created: Mon Aug 24 23:33:07 PDT 1992
 *
 * Modified: Dean Collins Sat Feb 12 16:47:43 PST 1994
 * Added code to make sure yylineno is defined (needed for Flex.)
 * If we've defined it it will not be a valid line number, but
 * at least the software will build.  (Someone tell me how to
 * do this right with Flex.)  Define -DFLEX when compiling lex.yy.c.
 *
 * Modified: Dean Collins Wed Feb 23 16:47:18 1994
 * Added tokens for dbtop, printer, printer_opts, mailprog and mailopts
 * lines.  Also added handling of continuation character, "\".
 *
 * Modified: Dean Collins Wed Mar 01 17:28:12 1994
 *   Added comma token for the pathlist for mail lines.  Can now do
 *              user    days    path1,path2,path3...
 *   to send mail to user only about problems below the specified paths.
 *   The paths don't need to be leaves.
 *
 * Modified: Dean Collins Wed Mar 02 18:07:24 1994
 *   Improved yyerror() error message _slightly_.
 *
 * Modified: Dean Collins Thu Jun  8 13:31:27 PDT 1995
 *   Replaced "#ifdef DEBUG" and "if (debug)" method of debug output
 *   with calls to the zdebug macros.
 *
 */

/*
 * Copyright (c) 1995,1994,1993,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */
%}

/* Defines go here */
slash   	"/"
uname		[a-zA-Z0-9%@!_.]+
pname		[^ #\t\n/,]+
abspath		({slash}{pname})+
relpath		{pname}{abspath}
eol		"\n"
continue 	"\\\n"
ws		[ \t]+
comment 	"#"[^\n]*
dbtop		dbtop:{ws}*
printer		printer:{ws}*
printer_opts	printer_opts:[^\n]*
mailer		mailer:{ws}*
mailer_opts	mailer_opts:[^\n]*
mail		mail:{ws}*
leaf		leaf:{ws}*
sysops		sysops:{ws}*
comma		","

%{
/* Includes here */
#include <stdlib.h>
#include <string.h>
#include "y.tab.h"
#include "zdbm.h"
#include "cloud.h"

/* Function prototypes */
/* Make sure it's not already defined as a macro */
#ifdef yywrap
#undef yywrap
#endif /* yywrap */
int yywrap() ;

/* GNU's Flex (an enhanced lex clone) doesn't seem to define yylineno.
 * Make sure it is defined.  This is sure to be needed under Linux.
 * Will someone please inform me how this is accomplished in Flex,
 * or if it is no longer necessary?
 */
#ifdef FLEX
int yylineno=-1 ;	/* Line number place-holder */
#endif /*FLEX*/

/* Define vars. here.  These are defined as GLOBAL, but should *only*
 * be used by the lexer/parser.
 */
char ParserPath[DBPATHLEN+1] ;		/* A file path */
char ParserName[MAXANAMELEN+1] ;	/* Something that looks like a usename */
int ParserDays ;		/* An integer value */
int parse_error=0 ;		/* How many errors have occured? */

%}
       /*--------------- Start of Lex expressions ------------------*/
%%


{ws}{eol}	{ zdebug("[EOL]") ; return(EOL) ; }

{eol}		{ zdebug("[EOL]") ; return(EOL) ; }

{ws}		{ zdebug("[WS]") ; return(WS) ; }

{continue}	{ zdebug("[WS(contin)]") ; return(WS) ; /*Turns continuation char into WS*/}

[0-9]+		{ zdebug1("[INT(%s)]", yytext) ; 
		  ParserDays = atoi((char *)yytext) ;
		  return(INT) ; 
		}

{uname}		{ zdebug1("[NAME(%s)]", yytext) ; 
                  strncpy(ParserName, (char *)yytext, MAXANAMELEN) ;
		  ParserName[MAXANAMELEN] = '\0' ;
                  return(NAME) ; 
		}

{relpath}	{ zdebug1("[RELPATH(%s)]", yytext) ; 
                  strncpy(ParserPath, (char *)yytext, DBPATHLEN) ;
		  ParserPath[DBPATHLEN] = '\0' ;
                  return(RELPATH) ; 
		}

{abspath}	{ zdebug1("[ABSPATH(%s)]", yytext) ; 
                  strncpy(ParserPath, (char *)yytext, DBPATHLEN) ;
		  ParserPath[DBPATHLEN] = '\0' ;
                  return(ABSPATH) ; 
		}

{dbtop}		{ zdebug("[DBTOP:]") ;
		  return(DBTOP) ;
		}

{mail}		{ zdebug("[MAILTOK:]") ;
		  return(MAILTOK) ;
		}

{leaf}		{ zdebug("[LEAFTOK:]") ;
		  return(LEAFTOK) ;
		}

{printer}	{ zdebug("[PRNTOK:]") ;
		  return(PRNTOK) ;
		}

{printer_opts}	{ zdebug("[PRNOPTOK:]") ;
			/* "13" is the length of "printer_opts:"; ignore it */
                  strncpy(ParserPath, StripLeading((char *)(yytext+13)),
		          DBPATHLEN) ;
		  ParserPath[DBPATHLEN] = '\0' ;
		  return(PRNOPTOK) ;
		}

{mailer}	{ zdebug("[MAILERTOK:]") ;
		  return(MAILERTOK) ;
		}

{mailer_opts}	{ zdebug("[MAILOPTOK:]") ;
			/* "12" is the length of "mailer_opts:"; ignore it */
                  strncpy(ParserPath, StripLeading((char *)(yytext+12)),
		          DBPATHLEN) ;
		  ParserPath[DBPATHLEN] = '\0' ;
		  return(MAILOPTOK) ;
		}

{sysops}	{ zdebug("[SYSOPTOK:]") ;
		  return(SYSOPTOK) ;
		}

{comma}		{ zdebug("[COMMA:]") ;
		  return(COMMA) ;
		}

{comment}{eol}	{ zdebug("[EOL]") ; return(EOL) ; /*Turns comments into EOLs*/}

{comment}$	{ zdebug("[EOL]") ; return(EOL) ; /*Turns comments into EOLs*/}


%%
/* Function defs here. */


int yywrap() { return(1) ; }


/* Modified 3/2/94, DC.  Should be _slightly_ more informative.
 * Still a *horrible* error handler.
 */
yyerror(s)
char *s ;
{   fprintf(stderr,"\n") ;
    fprintf(stderr, "*** config file syntax error\n") ;

	/* yylineno seems to be undefined in FLEX, so it's 
	 * been pre-set to -1.  (Sigh.)
	 */
    fprintf(stderr, "*** %s, line=", s) ;
    if (yylineno >=0) fprintf(stderr, "%d (approx.)", yylineno) ;
    else              fprintf(stderr, "<unknown>") ;

    fprintf(stderr, ", text = ") ;
    if (strcmp(yytext, "\n")) fprintf(stderr, "<new-line>\n") ;
    else                      fprintf(stderr, "'%s'\n", yytext) ;

    fprintf(stderr, "*** recently accepted strings: '%s', '%s'\n", 
	    ParserPath, ParserName) ;
    parse_error++ ;
}

