/*
 * config.h -- Configuration file parser header file.
 * Dean Collins
 *
 * Modified: Dean Collins, Wed Mar 02 18:16:12 1994
 *   Added PARSETEST & PARSEMISC, modified PARSE* values, and 
 *   added AddToSysopList() macro.
 */

/*
 * Copyright (c) 1995,1994,1992 Dean Collins.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that neither the name of the University of
 * Idaho nor the name of Dean Collins be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  Neither The University of Idaho
 * nor Dean Collins make any representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF IDAHO AND DEAN COLLINS DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include "pts.h"

/* Where is the pts config file located?  Over-ride at compile time and/or
 * in the config file.
 */
#ifndef CONFIGFILE
#define CONFIGFILE "/usr/local/lib/PTS/pts.cf"
#endif

/* Local defines here */
extern int parse_error ;

/* Types of parses to do.  These can be OR'd together to perform
 * multiple parses in a single pass (except for PARSETEST).
 */
#define PARSETEST 0
#define PARSEPATH 1
#define PARSEMAIL 2
#define PARSEMISC 4

/* Used by InStringList() to select the search type. */
#define EXACTCMP  1
#define PREFIXCMP 2

/* macros */
#define AddToSysopList(name,headp) AddToStringList(name,headp)

/* Prototypes */
int config_tree(struct Full_path **pathlist) ;
int config_mail(MailInfo **maillist) ;
int config_misc(void) ;
struct Full_path *AddPath(struct Full_path *head, char *path) ;
MailInfo *AddMail(MailInfo *head, char *username, int days,
		  StringListRec *pathlist) ;
int AddToStringList(char *name, StringListRec **headp);
int InStringList(char *name, StringListRec *p, int type);
int FreeStringList(StringListRec **headp) ;
