////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailMsgViewer
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailMsgViewer displays the contents of a mail message.
//		The display takes the form of a message area, with a Close
//		button.
//
//	Public Methods :
//		(Constructor) requires :
//			name		The name used for resource specs
//			message		The message to be viewed
//
//		refresh()	Refreshes the display.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailMsgViewer_h
#define mxMailMsgViewer_h
#ifdef __cplusplus

#include "akWindow.h"
#include "akButton.h"
#include "mxMailMsg.h"

class mxMailMsgDisplay;

class mxMailMsgViewer : public akWindow
{
	public:

		// Constructor and destructor

		mxMailMsgViewer(char *name,
			        const mxMailMsg& msg,
			        XtCallbackProc callback=0,
			        XtPointer clientData=0);
		~mxMailMsgViewer();

		// Update facility

		void		update();

		void		manage();

	private:

		// The message

		mxMailMsg	_msg;

		// Panel creation function/data

		Widget			createWorkArea(Widget);
		mxMailMsgDisplay	*_display;
		akButton		*_closeButton;

		// Callbacks for view panel options

		static void	listPageChanged(Widget,XtPointer,XtPointer);
		static void	closeCB(Widget,XtPointer,XtPointer);

		static void	fileOK(XtPointer,XtPointer);
		static void	fileCANCEL(XtPointer,XtPointer);

		XtCallbackProc	_userCB;
		XtPointer	_userData;
};

#endif
#endif
