////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailCompose
//
//	Author : Andy Jefferson
//
//	Description :
//
//	Public Methods :
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _mxMailCompose_h
#define _mxMailCompose_h
#ifdef __cplusplus

#include <string>
#include <vector>
#include "akWindow.h"
#include "akPromptString.h"
#include "akButton.h"
#include "akPixmap.h"
#include "akMessageDialog.h"
#include "mxMailAddressBook.h"
#include "mxMailAttachment.h"
#include "mxMailAttachmentSpecify.h"
#include "mxMailMsgDisplay.h"
#include "mxMailMsg.h"

typedef enum
{
	MX_MAIL_COMPOSE_BASIC,
	MX_MAIL_COMPOSE_ADDRESSEE,
	MX_MAIL_COMPOSE_REPLY,
	MX_MAIL_COMPOSE_FORWARD
} mxMailComposeType;

class mxMailCompose : public akWindow
{
	public:

		// Constructor, destructor etc

		mxMailCompose(char *name,
			mxMailAddressBook *book=0,
			mxMailComposeType type=MX_MAIL_COMPOSE_BASIC,
			mxMailAddress	*addressee=0,
			mxMailMsg *msg=0,
			XtCallbackProc callback=0,
			XtPointer clientData=0);
		~mxMailCompose();

	private:

		// Data members

		mxMailComposeType	_type;
		mxMailAddressBook	*_addressbook;

		XtCallbackProc		_userCB;
		XtPointer		_userData;

		// Panel widgets/methods

		mxMailMsgDisplay	*_display;
		akButton		*_sendAndQuitButton;
		akButton		*_sendAndContinueButton;
		akButton		*_addressbookButton;
		akButton		*_resetButton;
		akButton		*_cancelButton;
		akButton		*_addAttachmentButton;
		akButton		*_deleteAttachmentButton;
		akMessageDialog		*_confirmDialog;
		mxMailAttachmentSpecify	*_attachmentSpecifier;

		Widget			createWorkArea(Widget parent);

		// Function callbacks

		static	void	addressbookCB(Widget,XtPointer,XtPointer);
		static	void 	sendAndQuitCB(Widget,XtPointer,XtPointer);
		static	void	sendAndContinueCB(Widget,XtPointer,XtPointer);
		static	void 	quitCB(Widget,XtPointer,XtPointer);
		static	void 	resetCB(Widget,XtPointer,XtPointer);
		static	void 	quitOK(XtPointer,XtPointer);
		static	void 	quitCancel(XtPointer,XtPointer);
		static	void	addAttachmentCB(Widget,XtPointer,XtPointer);
		static	void	attachmentSpecifiedCB(Widget,XtPointer,XtPointer);
		static	void	deleteAttachmentCB(Widget,XtPointer,XtPointer);

		// Utility functions

		bool	 	send();
		string	 	signatureText();
		string		parseAddressList(string addresslist);
		static	string	fileText(string filename,bool indent);
};

#endif
#endif
