#include "mxMailAttachment.h"
#include "mxMailMsg.h"

////////////////////////////////////////////////////////////////////////////////
mxMailAttachment::mxMailAttachment()
	:_msg(0),
	 _file(0),
	 _type(MX_MESSAGE) {}
////////////////////////////////////////////////////////////////////////////////
mxMailAttachment::mxMailAttachment(const mxMailMsg& msg)
	:_file(0),
	 _type(MX_MESSAGE),
	 _subtype("rfc822")
	{_msg = new mxMailMsg(msg);}
////////////////////////////////////////////////////////////////////////////////
mxMailAttachment::mxMailAttachment(const mxMailFile& file)
	:_msg(0),
	 _type(MX_FILE)
	{_file = new mxMailFile(file);}
////////////////////////////////////////////////////////////////////////////////
mxMailAttachment::~mxMailAttachment()
{
	if (_msg)
	  delete _msg;
	if (_file)
	  delete _file;
}
////////////////////////////////////////////////////////////////////////////////
mxMailAttachment::mxMailAttachment(const mxMailAttachment& att)
	:_msg(0),
	 _file(0)
{
	if (att._msg)
	  _msg = new mxMailMsg(*(att._msg));
	if (att._file)
	  _file = new mxMailFile(*(att._file));
	_type = att._type;
	_subtype = att._subtype;
}
////////////////////////////////////////////////////////////////////////////////
mxMailAttachment&	mxMailAttachment::operator=(const mxMailAttachment& att)
{
	if (this != &att)
	  {
	   if (_msg)
	     delete _msg;
	   _msg = 0;
	   if (_file)
	     delete _file;
	   _file = 0;

	   if (att._msg)
	     _msg = new mxMailMsg(*(att._msg));
	   if (att._file)
	     _file = new mxMailFile(*(att._file));
	   _type = att._type;
	   _subtype = att._subtype;
	  }
	return *this;
}
