#include <string>
#include <iostream>
#include <cstdio>
#include <Xm/Notebook.h>
#include <Xm/ScrolledW.h>
#include <Xm/Protocols.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <X11/Xmu/Editres.h>

#include "mxMailAddressView.h"
#include "mxMailCompose.h"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAddressView::mxMailAddressView(Widget parent,
				     char *name,
				     mxMailAddressBook *book,
				     XtCallbackProc callback,
				     XtPointer clientData)
	:akDialog(name),
	 _addressbook(book),
	 _addressList((akList *)0),
	 _aliasField((akPromptString *)0),
	 _nameField((akPromptString *)0),
	 _addressField((akPromptString *)0),
	 _otherField((akPromptString *)0),
	 _closeButton((akButton *)0),
	 _insertAliasButton((akButton *)0),
	 _modifyAliasButton((akButton *)0),
	 _removeAliasButton((akButton *)0),
	 _sortByAliasButton((akButton *)0),
	 _sortByNameButton((akButton *)0),
	 _sortByAddressButton((akButton *)0),
	 _userCB(callback),
	 _userData(clientData)
{

//	Create addressbook viewing panel

	initialize(parent);

//	Update values in panel

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailAddressView::~mxMailAddressView()
{
	if (_addressList)
	  delete _addressList;
	if (_aliasField)
	  delete _aliasField;
	if (_nameField)
	  delete _nameField;
	if (_addressField)
	  delete _addressField;
	if (_otherField)
	  delete _otherField;
	if (_closeButton)
	  delete _closeButton;
	if (_insertAliasButton)
	  delete _insertAliasButton;
	if (_modifyAliasButton)
	  delete _modifyAliasButton;
	if (_removeAliasButton)
	  delete _removeAliasButton;
	if (_sortByAliasButton)
	  delete _sortByAliasButton;
	if (_sortByNameButton)
	  delete _sortByNameButton;
	if (_sortByAddressButton)
	  delete _sortByAddressButton;
}
////////////////////////////////////////////////////////////////////////////////
//
//	createWorkArea - create the panel contents
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailAddressView::createWorkArea(Widget parent)
{
	Widget		form;
	Widget		list_form;
	Widget		list_rowcol;
	Widget		field_rowcol;

//	Enable editres support

	XtAddEventHandler(_w,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach panel components to

	form =
		XtVaCreateManagedWidget("AddressForm",
					xmFormWidgetClass,
					parent,
					NULL);

//	Add buttons to messagebox

	XtVaSetValues(_w,
		      XmNautoUnmanage,FALSE,
		      XmNresizePolicy,XmRESIZE_NONE,
		      0);
	_closeButton =
	  new akButton(_w,"Close",mxClose_xpm,
			&mxMailAddressView::closeCB,(XtPointer)this);
	_closeButton->installHelp("Close the Address Book");
	_closeButton->manage();
	_insertAliasButton =
	  new akButton(_w,"Add",mxAdd_xpm,
			&mxMailAddressView::insertAliasCB,(XtPointer)this);
	_insertAliasButton->installHelp("Add an alias to\nthe Address Book");
	_insertAliasButton->manage();
	_modifyAliasButton =
	  new akButton(_w,"Modify",mxModify_xpm,
			&mxMailAddressView::modifyAliasCB,(XtPointer)this);
	_modifyAliasButton->installHelp("Modify an alias in\nthe Address Book");
	_modifyAliasButton->manage();
	_removeAliasButton =
	  new akButton(_w,"Delete",mxDelete_xpm,
			&mxMailAddressView::removeAliasCB,(XtPointer)this);
	_removeAliasButton->installHelp("Delete an alias from\nthe Address Book");
	_removeAliasButton->manage();
	XtVaSetValues(_w,XmNdefaultButton,_closeButton->baseWidget(),0);

//	Add area showing entry fields

	field_rowcol =
		XtVaCreateManagedWidget("AddressListRowcol",
					xmRowColumnWidgetClass,
					form,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNadjustLast,TRUE,
					NULL);
	_aliasField =
	  new akPromptString(field_rowcol,"AliasField","Alias");
	_aliasField->manage();
	_nameField =
	  new akPromptString(field_rowcol,"NameField","Full-Name");
	_nameField->manage();
	_addressField =
	  new akPromptString(field_rowcol,"AddressField","Mail Address");
	_addressField->manage();
	_otherField =
	  new akPromptString(field_rowcol,"OtherField","Other Details");
	_otherField->manage();

//	Add list showing current addresses, and sorting buttons

	list_form =
		XtVaCreateManagedWidget("AddressListForm",
					xmFormWidgetClass,
					form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_WIDGET,
					XmNbottomWidget,field_rowcol,
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					NULL);
	list_rowcol =
		XtVaCreateManagedWidget("AddressListRowcol",
					xmRowColumnWidgetClass,
					list_form,
					XmNtopAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNadjustLast,FALSE,
					NULL);
	_sortByAliasButton =
	  new akButton(list_rowcol,"Button",mxSortByAlias_xpm,
			&mxMailAddressView::sortByAliasCB,(XtPointer)this);
	_sortByAliasButton->installHelp("Sort addresses by Alias");
	_sortByAliasButton->manage();
	_sortByNameButton =
	  new akButton(list_rowcol,"Button",mxSortByName_xpm,
			&mxMailAddressView::sortByNameCB,(XtPointer)this);
	_sortByNameButton->installHelp("Sort addresses by Name");
	_sortByNameButton->manage();
	_sortByAddressButton =
	  new akButton(list_rowcol,"Button",mxSortByAddress_xpm,
			&mxMailAddressView::sortByAddressCB,(XtPointer)this);
	_sortByAddressButton->installHelp("Sort addresses by Address");
	_sortByAddressButton->manage();

	_addressList =
	  new akList(list_form,"AddressList",
		&mxMailAddressView::addressChangedCB,(XtPointer)this,
		&mxMailAddressView::addressActionedCB,(XtPointer)this);
	XtVaSetValues(_addressList->baseWidget(),
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_WIDGET,
		      XmNrightWidget,list_rowcol,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_FORM,
		      NULL);
	_addressList->manage();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Addressbook update function
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::setBook(mxMailAddressBook *book)
{
	_addressbook = book;

	update();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update function - set values in display
//
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::update()
{
//	Remove current addresses from list (if any)

	_addressList->empty();

//	Add addresses to list

	for (int addr_no=0;addr_no<_addressbook->noOfAddresses();addr_no++)
	  _addressList->insert(_addressbook->addressTitle(addr_no));

	_aliasField->clear();
	_nameField->clear();
	_addressField->clear();
	_otherField->clear();

//	Set display panel title line

	string	title_line;
	title_line = "AddressBook (" + _addressbook->filename() + ")";
	setTitle(title_line);
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::closeCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;

	obj->busy();
	obj->_addressbook->write();
	obj->unmanage();
	obj->ready();

//	If required, pass the selected alias back to the users callback

	if (obj->_userCB != (XtCallbackProc)0)
	  obj->_userCB(obj->_w,obj->_userData,0);
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::insertAliasCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;
	mxMailAddress		address;

	obj->busy();

	if (obj->_aliasField->value().empty())
	  {
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

//	Set up the address and add it

	address.setDetails(obj->_aliasField->value(),
			   obj->_nameField->value(),
			   obj->_addressField->value(),
			   obj->_otherField->value());
	obj->_addressbook->insert(address);

//	Update the display

	obj->update();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::modifyAliasCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;
	mxMailAddress		address;

	obj->busy();

//	Find which address is selected

	int	npos      = obj->_addressList->noSelectedPos();
	if (npos == 0)
	  {
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

	int	*positions = obj->_addressList->selectedPos();
	address.setDetails(obj->_aliasField->value(),
			   obj->_nameField->value(),
			   obj->_addressField->value(),
			   obj->_otherField->value());
	obj->_addressbook->modify(positions[0]-1,address);
	delete []positions;

//	Update the display

	obj->update();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::removeAliasCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;

	obj->busy();

//	Find which address is selected - and delete it

	int	npos = obj->_addressList->noSelectedPos();
	if (npos == 0)
	  {
	   XBell(XtDisplay(obj->_w),50);
	   obj->ready();
	   return;
	  }

	int	*positions = obj->_addressList->selectedPos();
	for (int i=0;i<npos;i++)
	  obj->_addressbook->remove(positions[i]-1);
	delete []positions;

//	Update the display

	obj->update();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::sortByAliasCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;

	obj->busy();
	obj->_addressbook->sortByAlias();
	obj->update();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::sortByNameCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;

	obj->busy();
	obj->_addressbook->sortByName();
	obj->update();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::sortByAddressCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;

	obj->busy();
	obj->_addressbook->sortByAddress();
	obj->update();
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::addressChangedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;
	XmListCallbackStruct	*cbs = (XmListCallbackStruct *)callData;
	mxMailAddress		address;

//	Set field values based on selected address

	obj->busy();

	address = obj->_addressbook->address(cbs->item_position-1);
	obj->_aliasField->setValue(address.alias());
	obj->_nameField->setValue(address.name());
	obj->_addressField->setValue(address.address());
	obj->_otherField->setValue(address.other());

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
void 	mxMailAddressView::addressActionedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;
	XmListCallbackStruct	*cbs = (XmListCallbackStruct *)callData;
	mxMailAddress		address;
	mxMailCompose		*compose;

//	Open a compose window 'to' the selected address

	obj->busy();

	address = obj->_addressbook->address(cbs->item_position-1);
	compose = new mxMailCompose("mxMailCompose",
				obj->_addressbook,
				MX_MAIL_COMPOSE_ADDRESSEE,&address,0,
				&mxMailAddressView::composeClosedCB,
				(XtPointer)obj);
	compose->manage();

	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Compose closed - delete the mxMailCompose object
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailAddressView::composeClosedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailAddressView	*obj = (mxMailAddressView *)clientData;
	mxMailCompose		*compose = (mxMailCompose *)callData;

	if (compose)
	  delete compose;
}
