////////////////////////////////////////////////////////////////////////////////
//
//	Class :	mxFtpMonitor
//
//	Author : Andy Jefferson
//
//	Description :
//		mxFtpMonitor monitors the size of a file on the local system
//		against a nominal required size.
//
//	Methods :
//
//	Limitations :
//		Can only be used to monitor LOCAL files (i.e not REMOTE files).
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxFtpMonitor_h
#define mxFtpMonitor_h
#ifdef __cplusplus

#include "akDialog.h"
#include "akLabel.h"

class mxFtpMonitor : public akDialog
{
	public:

		// Constructor

		mxFtpMonitor(Widget parent,
			     char *name,
			     int size,
			     string filename);
		~mxFtpMonitor();

		// Update function

		void		change(int size,string filename);
		virtual	void	unmanage();

	private:

		// Timeout callback

		static	void	checkSize(XtPointer,XtIntervalId*);

		// Panel creation methods/objects

		Widget		createWorkArea(Widget parent);
		akLabel		*_filenameLabel;
		akLabel		*_transferLabel;
		akLabel		*_statusLabel;

		// Data items

		XtIntervalId	_id;
		string		_filename;
		int		_reqdSize;
		time_t		_startTime;
};

#endif
#endif
