#!/bin/csh

#########################################################
# Installation script for STATICALLY bound mxFtp/mxMail #
#########################################################
#
# Set base directory to install mxMail/mxFtp - default "/usr/X11R6"
#
set MXBASEDIR="/usr/X11R6"
echo 'Installing mxMail/mxFtp in ' $MXBASEDIR
#
# Install Binaries
#
echo -n '>>> Installing statically bound mxMail in' $MXBASEDIR/bin '...'
cp ./bin/mxmail $MXBASEDIR/bin/mxmail
echo ' Done'
echo -n '>>> Installing statically bound mxFtp in' $MXBASEDIR/bin '...'
cp ./bin/mxftp $MXBASEDIR/bin/mxftp
echo ' Done'
#
# Install Documentation
#
echo -n '>>> Installing mxApps Documentation in' $MXBASEDIR/lib/mxapps/doc '...'
mkdir -p $MXBASEDIR/lib/mxapps/doc
cp ./lib/mxapps/doc/* $MXBASEDIR/lib/mxapps/doc/.
cp README $MXBASEDIR/lib/mxapps/doc/.
echo ' Done'
#
# Install Sound files
#
echo -n '>>> Installing mxApps sound files in' $MXBASEDIR/lib/mxapps/sounds '...'
mkdir -p $MXBASEDIR/lib/mxapps/sounds
cp ./lib/mxapps/sounds/* $MXBASEDIR/lib/mxapps/sounds/.
echo ' Done'
#
# Install App-Defaults
#
mkdir -p $MXBASEDIR/lib/X11/app-defaults
echo -n '>>> Installing mxMail resource file in' $MXBASEDIR/lib/X11/app-defaults '...'
cp ./lib/X11/app-defaults/mxMail $MXBASEDIR/lib/X11/app-defaults/mxMail
echo ' Done'
echo -n '>>> Installing mxFtp resource file in' $MXBASEDIR/lib/X11/app-defaults '...'
cp ./lib/X11/app-defaults/mxFtp $MXBASEDIR/lib/X11/app-defaults/mxFtp
echo ' Done'
#
# Installation complete
#
echo 'Installation complete'
