////////////////////////////////////////////////////////////////////////////////
//
//	Class : akSound
//
//	Author : Andy Jefferson
//
//	Description :
//		Utility for playing sound files.
//		Reads the file and checks the "type" (format). Play function
//		operates with the "type" that it has been associated.
//		Currently set up for Linux ONLY.
//
//	Public Methods :
//		(Constructor) requires :-
//			filename	Name of file containing sound.
//		play()			Plays the sound.
//		type()			Returns the sound-file "type".
//
//	Limitations :
//		* Currently only handles WAV and VOC files (and not ALL types).
//		* Code structure is based around assumption that all sound files
//		  will have a header area, which defines the length of data.
//		* Doesn't handle recording of sound files.
//		* No control over the locking of the audio device
//		* Specific to LINUX (/dev/dsp, and associated controls).
//		* Cannot work with CD-Rom's (music CD's).
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akSound_h
#define _akSound_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>

typedef enum
{
	AK_SOUND_NONE,
	AK_SOUND_WAV,
	AK_SOUND_VOC
} akSoundType;

class akSound
{
	public:

		akSound(string filename);
		~akSound();

		bool		play();
		bool		pause();
		bool		stop();

		bool		playing();
		bool		paused();

		akSoundType	type();

	private:

		int		_pid;
		akSoundType	_type;
		string		_filename;
		bool		_paused;

		void		checkType();
};

inline
akSoundType	akSound::type()
	{return _type;}
inline
bool	akSound::paused()
	{return _paused;}

#endif
#endif
