#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <iostream>

#include "akPromptInts.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptInts object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptInts::akPromptInts(Widget parent,
			     char *name,
			     string variable_name,
			     akPromptIntsCB callback,
			     XtPointer clientData)
	: akPrompt(parent,name,variable_name)
{
	userCB = callback;
	userClientData = clientData;

//	If a label prompt exists, change priority order so that the
//	label varies in size, and field is fixed size.

	if (_label != (Widget)0)
	  {
	   XtVaSetValues(_field,XmNleftAttachment,XmATTACH_NONE,NULL);
	   XtVaSetValues(_label,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_field,
			 NULL);
	  }

//	Set the initial value to be a single 0

	XmTextFieldSetString(_field,"0");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Pase Values from string
//
////////////////////////////////////////////////////////////////////////////////
int	*akPromptInts::parseValues(const char *string,int *num_values)
{
	int	*values;
	char	*temp_string;
	int	i,j,point_no,last_point;
	bool	space;

//	Count number of values in string

	*num_values = 0;
	space = true;
	for (i=0;i<strlen(string);i++)
	  {
	   if (string[i]==' ' || string[i]==',')
	     space = true;
	   else
	     {
	      if (space) (*num_values)++;
	      space = false;
	     }
	  }

//	If No values, return NULL pointer

	if (*num_values == 0)
	  return (int *)0;

//	Values exist so allocate array of ints

	values = new int[*num_values];

//	Read off ints into array

	temp_string = new char[strlen(string)+1];
	temp_string[0] = '\0';
	point_no   = -1;
	last_point = -1;
	space = true;
	j = 0;
	for (i=0;i<strlen(string);i++)
	  {
	   if (string[i]==' ' || string[i] == ',')
	     {
	      if (!space)
	        {
	         values[point_no] = atoi(temp_string);
		 last_point = point_no;
	        }
	      space = true;
	      j = 0;
	     }
	   else
	     {
	      temp_string[j] = string[i];j++;
	      temp_string[j] = '\0';
	      if (space) point_no++;
	      space = false;
	     }
	  }
	if (last_point < point_no)
	  values[point_no] = atoi(temp_string);
	delete temp_string;

	return values;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Values retrieval function
//
////////////////////////////////////////////////////////////////////////////////
int	*akPromptInts::value(int *num_values)
{
	char	*field_string;
	int	*values;

//	Retrieve field string and parse for values

	field_string = XmTextFieldGetString(_field);
	values = parseValues(field_string,num_values);

	return values;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInts::changeCB(string value)
{
	int	*values;
	int	num_values;

	if (userCB != (akPromptIntsCB)0)
	  {
	   values = parseValues(value.c_str(),&num_values);
	   (*userCB)(userClientData,values,num_values);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function for multiple value
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInts::setValue(int *new_values,int num_values)
{
	char	new_string[1000];
	char	temp_string[40];
	int	i;

	new_string[0] = '\0';
	if (num_values > 0)
	  {
	   sprintf(temp_string,"%d",new_values[0]);
	   strcat(new_string,temp_string);
	  }
	for (i=1;i<num_values;i++)
	  {
	   sprintf(temp_string,"  %d",new_values[i]);
	   strcat(new_string,temp_string);
	  }
	XmTextFieldSetString(_field,new_string);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function for single value
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInts::setValue(int new_value)
{
	char	temp_string[40];

	sprintf(temp_string,"%d",new_value);
	XmTextFieldSetString(_field,temp_string);
}
