////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptInt
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptInt class provides a data entry
//		prompt for an integer value. It creates a widget
//		consisting of an optional variable name label,
//		together with the actual data entry field.
//
//		Additionally, the entry field has up/down arrow
//		buttons alongside on the left, to provide incremental
//		increase/decrease of the integer. i.e as below
//		+------------------------------+---+-----------------+
//		|                              | ^ |                 |
//		| The prompt label             |   | Entry Area      |
//		|                              | v |                 |
//		+------------------------------+---+-----------------+
//		The user can retrieve the value from the class
//		via the function "value", or use a callback
//		hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	data passed to callback.
//		value()			Returns the int value entered
//		setValue()		Set the text field value
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptInt_h
#define _akPromptInt_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>
#include "akPrompt.h"

typedef void (*akPromptIntCB) (XtPointer clientData,int value);

class akPromptInt : public akPrompt
{
	public:

		// Constructor

		akPromptInt(Widget parent,
			     char *name,
			     string variable_name,
			     akPromptIntCB callback=0,
			     XtPointer clientData=0);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptInt");}

		// Access functions

		virtual int	value(void);
		virtual void	setValue(int new_value);

	protected:

		akPromptIntCB	userCB;
		XtPointer	userClientData;

		virtual void	changeCB(string field_string);

	private:

		virtual void	increaseValue(void);
		virtual void	decreaseValue(void);

		static void	increaseCB(Widget,XtPointer,XtPointer);
		static void	decreaseCB(Widget,XtPointer,XtPointer);
};

#endif
#endif
