////////////////////////////////////////////////////////////////////////////////
//
//	Class : akMessageDialog
//
//	Author : Andy Jefferson
//
//	Description :
//		The akMessageDialog is an object to provide standard dialogs.
//		It allows creation of the standard Motif dialogs -
//		QUESTION, WARNING, ERROR, WORKING, INFORMATION, MESSAGE
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			type		Dialog 'type'
//			modal		Is dialog modal ?
//			text		Message label
//			clientData	Data passed to callbacks
//			okCallback	Callback called when OK pressed
//			cancelCallback	Callback called when CANCEL pressed
//			helpCallback	Callback called when HELP pressed
//		setType()		Set the dialog type
//		setTitle()		Set the dialog title
//		setText()		Set the message text
//		setOKLabel()		Set the label on the OK button
//		setCancelLabel()	Set the label on the Cancel button
//		setHelpLabel()		Set the label on the Help button
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akMessageDialog_h
#define _akMessageDialog_h
#ifdef __cplusplus

#include "akComponent.h"
#include "akDialogCallbackData.h"

class akMessageDialog : public akComponent
{

	public:

		// Constructor/Destructor

		akMessageDialog(Widget parent,
				 char *name,
				 akMessageDialogType type = MESSAGE,
				 Boolean modal             = FALSE,
				 const char *text          = NULL,
				 void *clientData          = NULL,
				 akDialogCallback ok      = NULL,
				 akDialogCallback cancel  = NULL,
				 akDialogCallback help    = NULL);
		~akMessageDialog(void);

		// Update functions

		void		setType(const akMessageDialogType type);
		void		setTitle(string new_title);
		void		setText(string new_text);
		void		setOKLabel(string label);
		void		setCancelLabel(string label);
		void		setHelpLabel(string label);

	private:

		// Button pressed callback

		static void	actionCB(Widget,XtPointer,XtPointer);

		// Users callback data

		akDialogCallbackData	*_CBdata;
};

#endif
#endif
