////////////////////////////////////////////////////////////////////////////////
//
//	Author : Andy Jefferson
//
//	Description :
//		Contains a main routine for all akClass-based applications.
//
////////////////////////////////////////////////////////////////////////////////
// This example code is from the book:
//
// Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//    by
// Douglas Young
// Prentice Hall, 1995
// ISBN 0-13-20925507
//
// Copyright 1995 by Prentice Hall
// All Rights Reserved
//
// Permission to use, copy, modify, and distribute this software for 
// any purpose except publication and without fee is hereby granted, provided 
// that the above copyright notice appear in all copies of the software.
////////////////////////////////////////////////////////////////////////////////
#include "akApp.h"
#include <cassert>
#include <iostream>

int main(int argc,char **argv)
{
	bool	iconic=false;

// 	Ensure programmer has remembered to instantiate a akApp object

	assert(theAkApp);

//	Check on iconic requests

	for (int i=0;i<argc;i++)
	  if (strcmp(argv[i],"-iconic") == 0)
	    iconic = true;

// 	Init Intrinsics, build all windows, and enter event loop

	theAkApp->initialize(&argc,argv);

	if (iconic)
	  theAkApp->iconify();

	theAkApp->handleEvents();

	return 0;
}
