////////////////////////////////////////////////////////////////////////////////
//
//	Class : akFileDialog
//
//	Author : Andy Jefferson
//
//	Description :
//		The akFileDialog class provides a file selection dialog.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akFileDialog_h
#define _akFileDialog_h
#ifdef __cplusplus

#include <string>
#include "akComponent.h"
#include "akDialogCallbackData.h"

class akFileDialog : public akComponent
{

	public:

		// Constructor/Destructor

		akFileDialog(Widget parent,
			      char *name,
			      Boolean modal            = FALSE,
			      void *clientData         = NULL,
		  	      akDialogCallback ok     = NULL,
		  	      akDialogCallback cancel = NULL,
		  	      akDialogCallback help   = NULL);
		~akFileDialog(void);

		// Update functions

		void		setDirectory(string dir);
		void		setDefault(string file);
		void		setPattern(string pattern);
		void		setTitle(string title);
		void		setOKLabel(string label);
		void		setCancelLabel(string label);
		void		setHelpLabel(string label);

	private:

		// Button pressed callback

		static void actionCB(Widget,XtPointer,XtPointer);

		// Users callback data

		akDialogCallbackData	*_CBdata;
};

#endif
#endif
