////////////////////////////////////////////////////////////////////////////////
//
//	Class : akDialog
//
//	Author : Andy Jefferson
//
//	Description :
//		The akDialog class represents a dialog (transient) shell.
//		It is an XmTemplateDialog in effect. The component widget
//		stored is that of the messagebox.
//		The akDialog class cannot be instantiated directly - it
//		must be derived from. The derived class must provide a
//		createWorkArea function to create the contents of the window.
//		Additionally, the derived class MUST call the "initialize"
//		function to create the window (which calls the createWorkArea
//		function).
//
//	Public Methods :
//		(Constructor) requires :-
//			name		Name used in resource specifications.
//		initialize()		Creates the panel - the parameters
//					passed define which buttons appear
//					automatically a the foot of the panel.
//		busy()			Turns the cursor to a stopwatch
//		ready()			Turns the cursor back to normal
//		manage()		Manages the window
//		unmanage()		Unmanages the window
//		setDefaultPosition()	Sets the positioning method
//					TRUE=> position above parent,
//					FALSE=> position manually.
//		setTitle()		Sets the window title
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akDialog_h
#define _akDialog_h
#ifdef __cplusplus

#include "akComponent.h"
 
class akDialog : public akComponent
{
	public:

		akDialog(const char *class_name);

		// Window creation function (called by derived class)

		void	initialize(Widget parent,
				   XtPointer client_data=NULL,
				   char *ok_name=NULL,
				   XtCallbackProc ok_callback=NULL,
				   char *cancel_name=NULL,
				   XtCallbackProc cancel_callback=NULL,
				   char *help_name=NULL,
				   XtCallbackProc help_callback=NULL);

		// Manage/Unmanage

		virtual void 	manage(void);
		virtual void 	unmanage(void);

		// Busy/Ready

		virtual void 	busy(void);
		virtual void 	ready(void);

		void	setDefaultPosition(bool flag);
		void	setTitle(string title);

	protected:

		Widget	_workArea;	// Widget created by derived class

		// Derived classes must define this function to 
		// create the window-specific work area

		virtual Widget createWorkArea(Widget parent) = 0;

	private:
		void	busyWidget(Widget w);
		void	readyWidget(Widget w);

		static void	wmCloseCB(Widget,XtPointer,XtPointer);
};

#endif
#endif
