#include "akApp.h"
#include "akDialog.h"
#include <Xm/Form.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/Protocols.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/IntrinsicP.h>
#include <X11/CompositeP.h>
#include <X11/CoreP.h>
#include <cassert>
#include <iostream>
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
akDialog::akDialog(const char *name)
	: akComponent(name),
	  _workArea((Widget)0)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	Initialise function - create the shell and messagebox etc
//
////////////////////////////////////////////////////////////////////////////////
void	akDialog::initialize(Widget parent,
			        XtPointer clientData,
			        char *ok_name,
			        XtCallbackProc ok_callback,
			        char *cancel_name,
			        XtCallbackProc cancel_callback,
			        char *help_name,
			        XtCallbackProc help_callback)
{
	Arg		args[10];
	Atom		WM_DELETE_WINDOW;

//	Check for NULL parent

	assert(parent);

// 	Add a template dialog

	_w = XmCreateTemplateDialog(parent,_name,args,0);
	installDestroyHandler();

//	Override Window Manager close function

	XtVaSetValues(XtParent(_w),XmNdeleteResponse,XmDO_NOTHING,NULL);
	WM_DELETE_WINDOW = XmInternAtom(theAkApp->display(),"WM_DELETE_WINDOW",False);
	XmAddWMProtocolCallback(XtParent(_w),WM_DELETE_WINDOW,
				&akDialog::wmCloseCB,(XtPointer)this);

//	Ensure correct buttons are on messagebox

	if (ok_callback != NULL)
	  {
	   Widget button;

	   button = XtVaCreateManagedWidget("OK",
					    xmPushButtonWidgetClass,
					    _w,
					    NULL);
	   if (ok_name)
	     {
	      XmString xmstr=XmStringCreateLocalized(ok_name);
	      XtVaSetValues(button,XmNlabelString,xmstr,0);
	      XmStringFree(xmstr);
	     }
	   XtAddCallback(button,
			 XmNactivateCallback,
			 ok_callback,
			 (XtPointer)clientData);
	   XtVaSetValues(_w,XmNdefaultButton,button,0);
	  }
	if (cancel_callback)
	  {
	   Widget button;

	   button = XtVaCreateManagedWidget("Cancel",
					    xmPushButtonWidgetClass,
					    _w,
					    NULL);
	   if (cancel_name)
	     {
	      XmString xmstr=XmStringCreateLocalized(cancel_name);
	      XtVaSetValues(button,XmNlabelString,xmstr,0);
	      XmStringFree(xmstr);
	     }
	   XtAddCallback(button,
			 XmNactivateCallback,
			 cancel_callback,
			 (XtPointer)clientData);
	  }

	if (help_callback)
	  {
	   Widget button;

	   button = XtVaCreateManagedWidget("Help",
					    xmPushButtonWidgetClass,
					    _w,
					    NULL);
	   if (help_name)
	     {
	      XmString xmstr=XmStringCreateLocalized(help_name);
	      XtVaSetValues(button,XmNlabelString,xmstr,NULL);
	      XmStringFree(xmstr);
	     }
	   XtAddCallback(button,
			 XmNactivateCallback,
			 help_callback,
			 (XtPointer)clientData);
	  }

//	Add the work area

	_workArea = createWorkArea(_w);
	assert(_workArea);

// 	Manage the work area if the derived class hasn't already

	if (!XtIsManaged(_workArea))
	  XtManageChild(_workArea);
}
////////////////////////////////////////////////////////////////////////////////
//
//	wmCloseCB - close function for window manager
//
////////////////////////////////////////////////////////////////////////////////
void	akDialog::wmCloseCB(Widget,XtPointer clientData,XtPointer)
{
	akDialog	*obj = (akDialog *)clientData;

	obj->unmanage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	setDefaultPosition - use default positioning ?
//
////////////////////////////////////////////////////////////////////////////////
void	akDialog::setDefaultPosition(bool flag)
{
	if (!_w)
	  return;
	XtVaSetValues(_w,XmNdefaultPosition,flag,0);
} 
////////////////////////////////////////////////////////////////////////////////
//
//	setTitle - set title on menu-bar
//
////////////////////////////////////////////////////////////////////////////////
void	akDialog::setTitle(string title)
{
	if (!_w)
	  return;

	XmString	tempstr;
	tempstr = XmStringCreateLtoR((char *)title.c_str(),XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(_w,XmNdialogTitle,tempstr,0);
	XmStringFree(tempstr);
} 
////////////////////////////////////////////////////////////////////////////////
//
//	Manage
//
////////////////////////////////////////////////////////////////////////////////
void 	akDialog::manage(void)
{
	assert(_w);
	XtManageChild(_w);

	// Map the window, in case the window is iconified

	if (XtIsRealized(_w))
	XMapRaised(XtDisplay(_w),XtWindow(_w));
}
////////////////////////////////////////////////////////////////////////////////
//
//	Unmanage
//
////////////////////////////////////////////////////////////////////////////////
void 	akDialog::unmanage(void)
{
	assert(_w);
	XtUnmanageChild(_w);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Busy
//
////////////////////////////////////////////////////////////////////////////////
void 	akDialog::busy(void)
{
	assert(_w);

//	Set cursor for shell

	akComponent::busy();

//	Set cursor for all popups

	for (int i=0;i<_w->core.num_popups;i++)
	  if (XtIsRealized(_w->core.popup_list[i]))
	    busyWidget(_w->core.popup_list[i]);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Ready
//
////////////////////////////////////////////////////////////////////////////////
void 	akDialog::ready(void)
{
	assert(_w);

//	Set cursor for shell

	akComponent::ready();

//	Set cursor for all popups

	for (int i=0;i<_w->core.num_popups;i++)
	  if (XtIsRealized(_w->core.popup_list[i]))
	    readyWidget(_w->core.popup_list[i]);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set a widget to busy
//
////////////////////////////////////////////////////////////////////////////////
void	akDialog::busyWidget(Widget w)
{
	Display		*display=theAkApp->display();

	assert(w);

	if (display != (Display *)0 && XtWindow(w) != (Window)0)
	  XDefineCursor(display,XtWindow(w),_busyCursor);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set a widget to ready
//
////////////////////////////////////////////////////////////////////////////////
void 	akDialog::readyWidget(Widget w)
{
	Display		*display=theAkApp->display();

	assert(w);

	if (display != (Display *)0 && XtWindow(w) != (Window)0)
	  XUndefineCursor(display,XtWindow(w));
}
