////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailAddress
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailAddress is a representation of an address-book entry.
//		It consists of four parameters - alias, fullname, mail-address,
//		and 'other-details'.
//
//	Public Methods :
//		(Constructor) requires no parameters.
//		There are methods for setting and accessing each of the four
//		parameters.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailAddress_h
#define mxMailAddress_h
#ifdef __cplusplus

#include <string>

class mxMailAddress
{
	public:

		// Constructor, assignment operator etc

		mxMailAddress() {};
		mxMailAddress& operator=(const mxMailAddress& addr);
		mxMailAddress(const mxMailAddress& addr);

		// Access functions

		void		setDetails(string alias,string name,
					   string address,string other);
		const string&	alias() const;
		const string&	name() const;
		const string&	address() const;
		const string&	other() const;
		friend ostream&	operator<< (ostream& s,mxMailAddress& addr);

	private:

		// Address data items

		string	_alias;   	// Alias for the person
		string 	_name;		// Persons full name
		string 	_address;	// Persons mail address
		string	_other;		// Other (private) details about person
};

inline
mxMailAddress::mxMailAddress(const mxMailAddress& addr)
{
	_alias   = addr._alias;
	_name    = addr._name;
	_address = addr._address;
	_other   = addr._other;
}
inline
mxMailAddress&	mxMailAddress::operator=(const mxMailAddress& addr)
{
	if (this != &addr)
	  {
	   _alias   = addr._alias;
	   _name    = addr._name;
	   _address = addr._address;
	   _other   = addr._other;
	  }
	return *this;
}
inline
void	mxMailAddress::setDetails(string the_alias,string the_name,string the_address,string the_other)
{
	_alias   = the_alias;
	_name    = the_name;
	_address = the_address;
	_other   = the_other;
}
inline
ostream&	operator<<(ostream& s,mxMailAddress& addr)
{
	return s <<
		"mxMailAddress" << endl <<
		"  Alias:   " << addr._alias << endl <<
		"  Name:    " << addr._name << endl <<
		"  Address: " << addr._address << endl <<
		"  Other:   " << addr._other << endl;
}
inline
const string&	mxMailAddress::alias() const
	{return _alias;}
inline
const string&	mxMailAddress::name() const
	{return _name;}
inline
const string&	mxMailAddress::address() const
	{return _address;}
inline
const string&	mxMailAddress::other() const
	{return _other;}

#endif
#endif
