#!/bin/csh

##########################################################
# Installation script for DYNAMICALLY bound mxFtp/MxMail #
##########################################################
#
# Set base directory to install mxMail/mxFtp - default "/usr/local"
#
set MXBASEDIR="/usr/local"
echo 'Installing mxMail/mxFtp in ' $MXBASEDIR
#
# Install Binaries
#
echo -n '>>> Installing dynamically bound mxMail in' $MXBASEDIR/bin '...'
cp ./bin/mxmail $MXBASEDIR/bin/mxmail
echo ' Done'
echo -n '>>> Installing dynamically bound mxFtp in' $MXBASEDIR/bin '...'
cp ./bin/mxftp $MXBASEDIR/bin/mxftp
echo ' Done'
#
# Install Libraries
#
echo -n '>>> Installing AppKit libraries in' $MXBASEDIR/lib '...'
cp ./lib/libAppKit* $MXBASEDIR/lib/.
echo ' Done'
#
# Install Documentation
#
echo -n '>>> Installing mxApps Documentation in' $MXBASEDIR/lib/mxapps/doc '...'
mkdir -p $MXBASEDIR/lib/mxapps/doc
cp ./doc/* $MXBASEDIR/lib/mxapps/doc/.
cp *.html $MXBASEDIR/lib/mxapps/doc/.
cp README $MXBASEDIR/lib/mxapps/doc/.
echo ' Done'
#
# Install Sound files
#
echo -n '>>> Installing mxApps sound files in' $MXBASEDIR/lib/mxapps/sounds '...'
mkdir -p $MXBASEDIR/lib/mxapps/sounds
cp ./sounds/* $MXBASEDIR/lib/mxapps/sounds/.
echo ' Done'
#
# Install App-Defaults
#
mkdir -p $MXBASEDIR/lib/X11/app-defaults
echo -n '>>> Installing mxMail resource file in' $MXBASEDIR/lib/X11/app-defaults '...'
cp ./app-defaults/mxMail $MXBASEDIR/lib/X11/app-defaults/mxMail
echo ' Done'
echo -n '>>> Installing mxFtp resource file in' $MXBASEDIR/lib/X11/app-defaults '...'
cp ./app-defaults/mxFtp $MXBASEDIR/lib/X11/app-defaults/mxFtp
echo ' Done'
#
# Install Source and icons
#
mkdir -p $MXBASEDIR/src/mxapps/AppKit
echo -n '>>> Installing AppKit source in' $MXBASEDIR/src/mxapps/AppKit '...'
cp ./AppKit/*.[Ch] $MXBASEDIR/src/mxapps/AppKit/.
cp ./AppKit/Makefile $MXBASEDIR/src/mxapps/AppKit/.
echo ' Done'
mkdir -p $MXBASEDIR/src/mxapps/icons
echo -n '>>> Installing icons in' $MXBASEDIR/src/mxapps/icons '...'
cp ./icons/* $MXBASEDIR/src/mxapps/icons/.
echo ' Done'
mkdir -p $MXBASEDIR/src/mxapps/src
echo -n '>>> Installing mxMail/mxFtp source in' $MXBASEDIR/src/mxapps/src '...'
cp ./src/*.[Ch] $MXBASEDIR/src/mxapps/src/.
cp ./src/Makefile $MXBASEDIR/src/mxapps/src/.
echo ' Done'
#
# Installation complete
#
echo 'Installation complete'
