////////////////////////////////////////////////////////////////////////////////
//
//	Class : akMessageLine
//
//	Author : Andy Jefferson
//
//	Description :
//		The akMessageLine class provides a Motif label widget for
//		display of program information messages.
//		The access function "write" allows update of the message.
//		The input message REPLACES the current message.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akMessageLine_h
#define _akMessageLine_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akComponent.h"
#include "akMessageType.h"

class akMessageLine : public akComponent
{
	public:

		// Constructor

		akMessageLine(Widget parent,char *name);

		// Access functions

		void	write(akMessageType type,const char *, ...);

		// Class name

		virtual const char *const className(void)
			{return ("akMessageLine");}

	private:

		Widget	_label;
};

#endif
#endif
