////////////////////////////////////////////////////////////////////////////////
//
//	Class : akMessageArea
//
//	Author : Andy Jefferson
//
//	Description :
//		The akMessageArea class provides a scrolled Motif text widget
//		for display of application information/warning/error messages.
//
//		The access function "write" allows update of the message.
//		The input message is ADDED to the end of the current message.
//		The message appears on a new line UNLESS the type is ak_CONTINUE.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akMessageArea_h
#define _akMessageArea_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akComponent.h"
#include "akMessageType.h"

class akMessageArea : public akComponent
{
	public:

		// Constructor

		akMessageArea(Widget parent,char *name);

		// Access functions

		void	write(akMessageType message_type,const char *, ...);

		// Class name

		virtual const char *const className(void)
			{return ("akMessageArea");}

	private:

		Widget	_text;
};

#endif
#endif
