////////////////////////////////////////////////////////////////////////////////
//
//	Class : akDoc
//
//	Author : Andy Jefferson
//
//	Description :
//		The akDoc class provides an encapsulation of a document
//		containing several sections. The document is made up of a akDoc
//		object, which itself is made up of several akDocSection objects
//		to represent the sections.
//		The akDoc object contains the document filename from which it
//		was read, as well as a document title. Each akDocSection
//		contains the section text, as well as the section name.
//
//		The file read in should be in HTML format, however the akDoc
//		class only currently understands the following tags :-
//		H1, /H1, H2, /H2, H3, /H3, PRE, /PRE, P, TITLE, /TITLE
//
//	Public Methods :
//
//	Limitations :
//		No capability to represent different fonts, underlining,
//		figures, etc, etc (i.e it is (single-font text-only).
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akDoc_h
#define _akDoc_h
#ifdef __cplusplus

#include <vector>
#include <string>

class akDocSection
{
	public:

		// Constructor etc

		akDocSection();
		akDocSection(const akDocSection& sect);
		akDocSection(string title,string text);
		akDocSection& operator=(const akDocSection &sect);

		// Access functions

		string	name();
		string	text();

	protected:

		string	_name;
		string	_text;
};

class akDoc
{
	public:

		// Constructor etc

		akDoc();
		akDoc(string file);
		akDoc(const akDoc& doc);
		akDoc& operator=(const akDoc& doc);

		// Access functions

		string	filename();
		string	title();
		int	noOfSections();
		string	sectionText(int secNo);
		string	sectionName(int secNo);

	protected:

		vector<akDocSection>	_sections;
		string			_title;
		string			_filename;

	private:

		// Private functions used internally in reading document

		void	readFile(void);
		void	replaceLineEnds(string& line);
		void	formatSection(string& line);
};

inline
string	akDoc::filename()
	{return _filename;}
inline
string	akDoc::title()
	{return _title;}
inline
string	akDocSection::name()
	{return _name;}
inline
string	akDocSection::text()
	{return _text;}
inline
int	akDoc::noOfSections()
	{return _sections.size();}
inline
string	akDoc::sectionText(int secNo)
{
	if (secNo < 0 || secNo >= _sections.size())
	  return "";
	return _sections[secNo].text();
}
inline
string	akDoc::sectionName(int secNo)
{
	if (secNo < 0 || secNo >= _sections.size())
	  return "";
	return _sections[secNo].name();
}

#endif
#endif
