#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <iostream>

#include "akCheckBox.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akCheckBox object.
//
////////////////////////////////////////////////////////////////////////////////
akCheckBox::akCheckBox(Widget parent,
			 char *name,
			 char *prompt,
			 char **options,
			 int num_options,
			 int num_columns,
			 XtCallbackProc callback,
			 XtPointer clientData)
	: akComponent(name),
	  _userCB(callback),
	  _userData(clientData),
	  _callbackStruct((akCheckBoxCallbackStruct *)0)
{
	Arg		args[10];
	int		ncols;

	_numOptions = num_options;

//	Add frame and optional prompt as frame label

	XtSetArg(args[0],XmNshadowType,XmSHADOW_ETCHED_OUT);
	_w = XmCreateFrame(parent,_name,args,1);
	if (prompt != (char *)0)
	  XtVaCreateManagedWidget(prompt,
				  xmLabelWidgetClass,
				  _w,
				  XmNchildType,XmFRAME_TITLE_CHILD,
				  NULL);

//	Create check box widget

	ncols = num_columns;
	if (num_columns < 1 || num_columns > _numOptions)
	  ncols = 1;

	XtSetArg(args[0],XmNnumColumns,ncols);
	XtSetArg(args[1],XmNorientation,XmVERTICAL);
	XtSetArg(args[2],XmNpacking,XmPACK_COLUMN);
	XtSetArg(args[3],XmNadjustLast,FALSE);
	_checkBox = XmCreateSimpleCheckBox(_w,_name,args,4);
	XtManageChild(_checkBox);
	installDestroyHandler();

//	Add options (not adding in above since it ignores any toggle resources specified)

	for (int i=0;i<_numOptions;i++)
	  {
	   char		button_name[20];
	   XmString	option_label;

	   sprintf(button_name,"button_%d",i);
	   option_label = XmStringCreateLocalized(options[i]);
	   XtVaCreateManagedWidget(button_name,
				   xmToggleButtonWidgetClass,
				   _checkBox,
				   XmNindicatorSize,20,
				   XmNindicatorType,XmN_OF_MANY,
				   XmNindicatorOn,XmINDICATOR_CHECK_BOX,
				   XmNlabelString,option_label,
				   0);
	  }

//	If user wants dynamic hook, call changeCB whenever anything changes.

	if (_userCB != (XtCallbackProc)0)
	  {
	   for (int i=0;i<_numOptions;i++)
	     XtAddCallback(optionWidget(i),
			   XmNvalueChangedCallback,
			   akCheckBox::changeCB,
			   (XtPointer)this);

	   // Allocate callback struct
	   _callbackStruct = new akCheckBoxCallbackStruct;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akCheckBox::~akCheckBox()
{
	if (_callbackStruct)
	  delete _callbackStruct;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option changed callback
//
////////////////////////////////////////////////////////////////////////////////
void	akCheckBox::changeCB(Widget w,XtPointer clientData,XtPointer callData)
{
	XmToggleButtonCallbackStruct *cbs =
		(XmToggleButtonCallbackStruct *)callData;
	akCheckBox	*obj = (akCheckBox *)clientData;
	char		*button_name;
	char		*option;

//	Check which button was changed

	button_name = XtName(w);
	option = &(button_name[7]);

//	Update akCheckBoxCallbackStruct

	obj->_callbackStruct->option_no = atoi(option);
	if (cbs->set == 1)
	  obj->_callbackStruct->value = TRUE;
	else
	  obj->_callbackStruct->value = FALSE;

//	Call user's own routine with their clientData

	obj->_userCB(obj->_checkBox,obj->_userData,(XtPointer)obj->_callbackStruct);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Option widget access function
//
////////////////////////////////////////////////////////////////////////////////
Widget	akCheckBox::optionWidget(int option_no)
{
	Widget	*children;
	char	button_name[20];
	int	num_children;
	int	i;

	if (option_no < 0 || option_no > _numOptions-1)
	  return (Widget)0;
	else
	  {
	   XtVaGetValues(_checkBox,
			 XmNchildren,&children,
			 XmNnumChildren,&num_children,
			 NULL);
	   sprintf(button_name,"button_%d",option_no);
	   for (i=0;i<num_children;i++)
	     if (strcmp(XtName(children[i]),button_name) == 0)
	       return children[i];

	   return (Widget)0;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Select an option
//
////////////////////////////////////////////////////////////////////////////////
void	akCheckBox::set(int option_no)
{
	if (option_no < 0 || option_no > _numOptions-1)
	  return;
	else
	  if (optionWidget(option_no) != (Widget)0)
	    XtVaSetValues(optionWidget(option_no),XmNset,TRUE,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Deselect an option
//
////////////////////////////////////////////////////////////////////////////////
void	akCheckBox::unset(int option_no)
{
	if (option_no < 0 || option_no > _numOptions-1)
	  return;
	else
	  if (optionWidget(option_no) != (Widget)0)
	    XtVaSetValues(optionWidget(option_no),XmNset,FALSE,NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Is an option selected ?
//
////////////////////////////////////////////////////////////////////////////////
bool	akCheckBox::selected(int option_no)
{
	bool	selection;

	if (option_no < 0 || option_no > _numOptions-1)
	  return FALSE;
	else
	  {
	   if (optionWidget(option_no) != (Widget)0)
	     {
	      XtVaGetValues(optionWidget(option_no),XmNset,&selection,NULL);
	      return selection;
	     }
	   else
	     return FALSE;
	  }
}
