////////////////////////////////////////////////////////////////////////////////
//
//	Class : akButton
//
//	Author : Andy Jefferson
//
//	Description :
//		akButton represents an XmPushButton displaying either a
//		label or a pixmap. Whenever the button is pressed, the callback
//		is invoked. Cursor is changed to a hand when over the button.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of button
//			name		name used in resource specifications
//		either	pix		XPM representation of pixmap
//		or	pix_width	Pixmap width
//			pix_height	Pixmap height
//			pix_bits	XBM representaion of bits
//		or	label		Label
//		setMnemonic()		Sets the mnemonic (label version only).
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akButton_h
#define _akButton_h
#ifdef __cplusplus

#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include "akPixmap.h"
#include "akComponent.h"
////////////////////////////////////////////////////////////////////////////////
class akButton : public akComponent
{
	public:

		// Constructor/Destructor

		akButton(Widget parent,		// Bitmap
			  char *name,
			  int pix_width,
			  int pix_height,
			  char pix_bits[],
			  XtCallbackProc callback,
			  XtPointer clientData);
		akButton(Widget parent,		// Pixmap
			  char *name,
			  char **pix,
			  XtCallbackProc callback,
			  XtPointer clientData);
		akButton(Widget parent,		// Label
			  char *name,
			  char *label,
			  XtCallbackProc callback,
			  XtPointer clientData);
		~akButton(void);

		// Class name

		virtual const char *const className(void)
			{return ("akButton");}

		void	setMnemonic(char mnemonic);

	private:

		XtCallbackProc	_userCB;
		XtPointer	_userData;
		akPixmap	*_pixmap;
		Pixel		_topShadowColor;
		Pixel		_bottomShadowColor;
		Pixel		_backgroundColor;

		static	void	activateCB(Widget,XtPointer,XtPointer);
		static	void	enterWindowCB(Widget,XtPointer,XEvent*,Boolean*);
		static	void	leaveWindowCB(Widget,XtPointer,XEvent*,Boolean*);
};
inline
void	akButton::setMnemonic(char mnemonic)
	{XtVaSetValues(_w,XmNmnemonic,mnemonic,0);}
inline
void	akButton::activateCB(Widget,XtPointer clientData,XtPointer)
{
	akButton	*obj = (akButton *)clientData;

	obj->_userCB(obj->_w,obj->_userData,(XtPointer)0);
}

#endif
#endif
