#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/MwmUtil.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <iostream>

#include "akButton.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XBM
//
////////////////////////////////////////////////////////////////////////////////
akButton::akButton(Widget parent,
		     char *name,
		     int pix_width,
		     int pix_height,
		     char pix_bits[],
		     XtCallbackProc callback,
		     XtPointer clientData)
	: akComponent(name),
	  _pixmap((akPixmap *)0),
	  _userCB(callback),
	  _userData(clientData),
	  _topShadowColor(0),
	  _bottomShadowColor(0),
	  _backgroundColor(0)
{
	Arg		args[10];
	Pixmap		pixmap,insens_pixmap;

//	Create the pixmap

	_pixmap = new akPixmap(pix_width,pix_height,pix_bits);
	pixmap = _pixmap->pixmap();
	insens_pixmap = _pixmap->insensitive();

//	Create push button widget

	if (pixmap != (Pixmap)0)
	  {
	   XtSetArg(args[0],XmNlabelType,XmPIXMAP);
	   XtSetArg(args[1],XmNlabelPixmap,pixmap);
	   XtSetArg(args[2],XmNlabelInsensitivePixmap,insens_pixmap);
	   _w = XmCreatePushButton(parent,_name,args,3);
	  }
	else
	  _w = XmCreatePushButton(parent,_name,args,0);
	installDestroyHandler();
	XtVaGetValues(_w,
		XmNtopShadowColor,&_topShadowColor,
		XmNbottomShadowColor,&_bottomShadowColor,
		XmNbackground,&_backgroundColor,
		0);
	XtVaSetValues(_w,
		XmNtopShadowColor,_backgroundColor,
		XmNbottomShadowColor,_backgroundColor,
		XmNmarginWidth,0,
		XmNmarginHeight,0,
		0);

//	Add enter/leave handlers

	XtAddEventHandler(_w,EnterWindowMask,FALSE,
		&akButton::enterWindowCB,(XtPointer)this);
	XtAddEventHandler(_w,LeaveWindowMask,FALSE,
		&akButton::leaveWindowCB,(XtPointer)this);

//	Register the activate callback (if supplied)

	if (callback != (XtCallbackProc)0)
	  XtAddCallback(_w,
			XmNactivateCallback,
			akButton::activateCB,
			(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XPM
//
////////////////////////////////////////////////////////////////////////////////
akButton::akButton(Widget parent,
		     char *name,
		     char **pix,
		     XtCallbackProc callback,
		     XtPointer clientData)
	: akComponent(name),
	  _pixmap((akPixmap *)0),
	  _userCB(callback),
	  _userData(clientData),
	  _topShadowColor(0),
	  _bottomShadowColor(0),
	  _backgroundColor(0)
{
	Arg		args[10];
	Pixmap		pixmap,insens_pixmap;
	
//	Create the pixmap

	_pixmap = new akPixmap(pix);
	pixmap = _pixmap->pixmap();
	insens_pixmap = _pixmap->insensitive();

//	Create push button widget

	XtSetArg(args[0],XmNlabelType,XmPIXMAP);
	if (pixmap != (Pixmap)0)
	  {
	   XtSetArg(args[0],XmNlabelType,XmPIXMAP);
	   XtSetArg(args[1],XmNlabelPixmap,pixmap);
	   XtSetArg(args[2],XmNlabelInsensitivePixmap,insens_pixmap);
	   _w = XmCreatePushButton(parent,_name,args,3);
	  }
	else
	  _w = XmCreatePushButton(parent,_name,args,0);
	installDestroyHandler();
	XtVaGetValues(_w,
		XmNtopShadowColor,&_topShadowColor,
		XmNbottomShadowColor,&_bottomShadowColor,
		XmNbackground,&_backgroundColor,
		0);
	XtVaSetValues(_w,
		XmNtopShadowColor,_backgroundColor,
		XmNbottomShadowColor,_backgroundColor,
		XmNmarginWidth,0,
		XmNmarginHeight,0,
		0);

//	Add enter/leave handlers to change cursor

	XtAddEventHandler(_w,EnterWindowMask,FALSE,
		&akButton::enterWindowCB,(XtPointer)this);
	XtAddEventHandler(_w,LeaveWindowMask,FALSE,
		&akButton::leaveWindowCB,(XtPointer)this);

//	Register the activate callback (if supplied)

	if (callback != (XtCallbackProc)0)
	  XtAddCallback(_w,
			XmNactivateCallback,
			akButton::activateCB,
			(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - label
//
////////////////////////////////////////////////////////////////////////////////
akButton::akButton(Widget parent,
		   char *name,
		   char *label,
		   XtCallbackProc callback,
		   XtPointer clientData)
	: akComponent(name),
	  _pixmap((akPixmap *)0),
	  _userCB(callback),
	  _userData(clientData),
	  _topShadowColor(0),
	  _bottomShadowColor(0),
	  _backgroundColor(0)
{
	Arg		args[10];
	XmString	label_string;

//	Create push button widget

	_w = XmCreatePushButton(parent,_name,args,0);
	if (label)
	   {
	    label_string = XmStringCreateLtoR(label,XmFONTLIST_DEFAULT_TAG);
	    XtVaSetValues(_w,
			XmNlabelType,XmSTRING,
			XmNlabelString,label_string,
			0);
	    XmStringFree(label_string);
	   }
	installDestroyHandler();
	XtVaGetValues(_w,
		XmNtopShadowColor,&_topShadowColor,
		XmNbottomShadowColor,&_bottomShadowColor,
		XmNbackground,&_backgroundColor,
		0);
	XtVaSetValues(_w,
		XmNtopShadowColor,_backgroundColor,
		XmNbottomShadowColor,_backgroundColor,
		XmNmarginWidth,0,
		XmNmarginHeight,0,
		0);

//	Add enter/leave handlers to change cursor

	XtAddEventHandler(_w,EnterWindowMask,FALSE,
		&akButton::enterWindowCB,(XtPointer)this);
	XtAddEventHandler(_w,LeaveWindowMask,FALSE,
		&akButton::leaveWindowCB,(XtPointer)this);

//	Register the activate callback (if supplied)

	if (callback != (XtCallbackProc)0)
	  {
	   XtAddCallback(_w,
			 XmNactivateCallback,
			 akButton::activateCB,
			 (XtPointer)this);
	   _userCB   = callback;
	   _userData = clientData;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akButton::~akButton()
{
	if (_pixmap)
	  delete _pixmap;
}
////////////////////////////////////////////////////////////////////////////////
//
//	EnterWindow callback
//
////////////////////////////////////////////////////////////////////////////////
void	akButton::enterWindowCB(Widget w,XtPointer clientData,XEvent*,Boolean*)
{
	akButton	*obj = (akButton *)clientData;

	Cursor	cursor = XCreateFontCursor(XtDisplay(w),XC_hand2);
	XDefineCursor(XtDisplay(w),XtWindow(w),cursor);
	XmUpdateDisplay(w);
	XtVaSetValues(w,
		XmNtopShadowColor,obj->_topShadowColor,
		XmNbottomShadowColor,obj->_bottomShadowColor,
		0);
	XmProcessTraversal(w,XmTRAVERSE_CURRENT);
}
////////////////////////////////////////////////////////////////////////////////
//
//	LeaveWindow callback
//
////////////////////////////////////////////////////////////////////////////////
void	akButton::leaveWindowCB(Widget w,XtPointer clientData,XEvent*,Boolean*)
{
	akButton	*obj = (akButton *)clientData;

	XUndefineCursor(XtDisplay(w),XtWindow(w));
	XmUpdateDisplay(w);
	XtVaSetValues(w,
		XmNtopShadowColor,obj->_backgroundColor,
		XmNbottomShadowColor,obj->_backgroundColor,
		0);
}
