#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <stdio.h>
#include <ctype.h>

#include "mxQuotedPrintableString.h"

static	istrstream	*inputstr;

/*
 * mapping of printable characters (and HT) to ASCII values.  On an
 * ASCII machine, this is an identity, but on a non-ASCII machine,
 * it is necessary to define this mapping.  This is used to decode single
 * characters into their binary equivalents.
 *
 * Some of these might have to be commented out if the characters aren't
 * representable on an particular machine
 */
struct {
    char input;
    unsigned char output;
} decoding [] = {
    /* SPACE, HT */
    {'\t',  '\011'}, {' ',   '\040'}, 
    /* EXCLAMATION POINT through LESS THAN */
    {'!',   '\041'}, {'"',   '\042'}, {'#',   '\043'}, {'$',   '\044'},
    {'%',   '\045'}, {'&',   '\046'}, {'\'',  '\047'}, {'(',   '\050'},
    {')',   '\051'}, {'*',   '\052'}, {'+',   '\053'}, {',',   '\054'},
    {'-',   '\055'}, {'.',   '\056'}, {'/',   '\057'}, {'0',   '\060'},
    {'1',   '\061'}, {'2',   '\062'}, {'3',   '\063'}, {'4',   '\064'},
    {'5',   '\065'}, {'6',   '\066'}, {'7',   '\067'}, {'8',   '\070'},
    {'9',   '\071'}, {':',   '\072'}, {';',   '\073'}, {'<',   '\074'},
    /* GREATER THAN through TILDE */
    {'>',   '\076'}, {'?',   '\077'}, {'@',   '\100'}, {'A',   '\101'},
    {'B',   '\102'}, {'C',   '\103'}, {'D',   '\104'}, {'E',   '\105'},
    {'F',   '\106'}, {'G',   '\107'}, {'H',   '\110'}, {'I',   '\111'},
    {'J',   '\112'}, {'K',   '\113'}, {'L',   '\114'}, {'M',   '\115'},
    {'N',   '\116'}, {'O',   '\117'}, {'P',   '\120'}, {'Q',   '\121'},
    {'R',   '\122'}, {'S',   '\123'}, {'T',   '\124'}, {'U',   '\125'}, 
    {'V',   '\126'}, {'W',   '\127'}, {'X',   '\130'}, {'Y',   '\131'}, 
    {'Z',   '\132'}, {'[',   '\133'}, {'\\',  '\134'}, {']',   '\135'}, 
    {'^',   '\136'}, {'_',   '\137'}, {'`',   '\140'}, {'a',   '\141'}, 
    {'b',   '\142'}, {'c',   '\143'}, {'d',   '\144'}, {'e',   '\145'}, 
    {'f',   '\146'}, {'g',   '\147'}, {'h',   '\150'}, {'i',   '\151'}, 
    {'j',   '\152'}, {'k',   '\153'}, {'l',   '\154'}, {'m',   '\155'}, 
    {'n',   '\156'}, {'o',   '\157'}, {'p',   '\160'}, {'q',   '\161'}, 
    {'r',   '\162'}, {'s',   '\163'}, {'t',   '\164'}, {'u',   '\165'}, 
    {'v',   '\166'}, {'w',   '\167'}, {'x',   '\170'}, {'y',   '\171'}, 
    {'z',   '\172'}, {'{',   '\173'}, {'|',   '\174'}, {'}',   '\175'}, 
    {'~',   '\176'},
};

struct {
    char input;
    unsigned char output;
} decode_hex [] = {
    { '0',  0 }, { '1',  1 }, { '2',  2 }, { '3',  3 }, { '4',  4 },
    { '5',  5 }, { '6',  6 }, { '7',  7 }, { '8',  8 }, { '9',  9 },
    { 'a', 10 }, { 'A', 10 }, { 'b', 11 }, { 'B', 11 }, { 'c', 12 },
    { 'C', 12 }, { 'd', 13 }, { 'D', 13 }, { 'e', 14 }, { 'E', 14 },
    { 'f', 15 }, { 'F', 15 },
};

bool			mxQuotedPrintableString::_initial=false;
int			mxQuotedPrintableString::_unHex0[256];
int			mxQuotedPrintableString::_unHex1[256];
unsigned char		mxQuotedPrintableString::_magic[256];
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxQuotedPrintableString::mxQuotedPrintableString()
{
	if (!_initial)
	   {
	    // Set up static data for decode

	    for (int i=0;i<sizeof(decoding)/sizeof(*decoding);++i)
	      _magic[decoding[i].input] = decoding[i].output;
	    for (int i=0;i<sizeof(_unHex0)/sizeof(*_unHex0);++i)
	       {
		_unHex0[i] = ~0;
		_unHex1[i] = ~0;
	       }
	    for (int i=0;i<sizeof(decode_hex)/sizeof(*decode_hex);++i)
	       {
		_unHex0[decode_hex[i].input] = decode_hex[i].output;
		_unHex1[decode_hex[i].input] = decode_hex[i].output << 4;
	       }

	    _initial = true;
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	decode
//		text mode   - EORs become newlines
//		binary mode - EORs become CR LF
//
////////////////////////////////////////////////////////////////////////////////
string	mxQuotedPrintableString::decode(string the_input,bool text_mode)
{
	string		output;
	unsigned char	buf[100];	/* never larger than 73 */
	register unsigned char *ptr;
	register unsigned char *src;
	register int	c;
	int		newline = 0;
	int		eof = 0;
	int		lineno = 1;
	int		badchar = 0;

	inputstr = new istrstream((char *)the_input.c_str(),the_input.size());

	while (!eof)
	   {
	    // read a line into the buffer
	    ptr = buf;
	    while (ptr < buf + sizeof(buf))
	       {
		c = inputstr->get();
		if (c == EOF)
		   {
		    eof = 1;
		    break;
		   }
		if (isEndOfLine(c))
		  break;
		*ptr++ = c;
	       }
	    // trim trailing spaces and tabs
	    --ptr;	// point to last character read in
	    while ((*ptr == ' ' || *ptr == '\t') && ptr >= buf)
	      --ptr;

	    // if EOF occurred at start of line, we're done */
	    if (eof && ptr <= buf)
	      break;

	    // decode 'buf'
	    // ptr now points to last non-space char (may be (buf-1))
	    newline = 1;
	    src = buf;
	    while (src <= ptr)
	       {
		if (*src == '=')
		   {
		    if (src == ptr)
		       {
			newline = 0;
			break;
		       }
		    else
		       {
			++src;	// skip over '='
			c = _unHex1[*src++];
			c |= _unHex0[*src++];
			if (c == ~0)
			  ++badchar;
			output += (char)c;
		       }
		   }
		else if (_magic[*src])
		   {
		    // output the octet corresponding to this character in ASCII
		    output += (char)_magic[*src];
		    ++src;
		   }
		else
		   {
		    // ignore weird chars
		    ++src;
		   }
	       }
	    if (newline)
	       {
		if (text_mode)
		   {
		    output += '\n';
		   }
		else
		   {
		    output += (char)0x0d;
		    output += (char)0x0a;
		   }
	       }
//	    if (badchar)
//	      cout << "illegal hex character(s) on line " << lineno << endl;
	    ++lineno;
	   }

//	delete inputstr;

	return output;
}

// check to see if we are at end of line.  Either \n (newline) or CR LF
// suffices as end-of-line.  If the latter, we eat the LF character so that
// the next character read will be the first character of the next line.
int	mxQuotedPrintableString::isEndOfLine(int c)
{
	if (c == '\n')
	  return 1;
	else if (c == '\r')
	   {
	    c = inputstr->get();
	    if (c == '\n' || c == EOF)
	      return 1;
	    inputstr->putback((char)c);
	   }
	return 0;
}
