////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailAddressView
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailAddressView is a display of an addressbook. It is passed
//		a pointer to an mxMailAddressBook at construction and displays
//		the addresses from that addressbook in a panel. The user is
//		allowed to add, delete and modify addresses.
//
//	Public Methods :
//		(Constructor) requires :
//			parent		Widget used as paretn of the panel.
//			name		Name used for resource specifications.
//			book		Pointer to mxMailAddressBook object.
//			callback	Callback called when panel is closed.
//			clientData	Client Data passed to the callback.
//
//		update()	Removes all addresses from the list and
//				re-adds them. The fields are cleared.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailAddressView_h
#define mxMailAddressView_h
#ifdef __cplusplus

#include <std/string.h>
#include "akDialog.h"
#include "akButton.h"
#include "akPromptString.h"
#include "akList.h"
#include "mxMailAddressBook.h"

class mxMailAddressView : public akDialog
{
	public:

		// Constructor and destructor

		mxMailAddressView(Widget parent,
				  char *name,
				  mxMailAddressBook *book,
				  XtCallbackProc callback=0,
				  XtPointer clientData=0);
		~mxMailAddressView();

		// Update

		const	mxMailAddressBook&	book();
		void				setBook(mxMailAddressBook *book);
		void				update();

	private:

		mxMailAddressBook	*_addressbook;

		// Panel functions/components

		Widget		createWorkArea(Widget parent);
		akList		*_addressList;
		akPromptString	*_aliasField;
		akPromptString	*_nameField;
		akPromptString	*_addressField;
		akPromptString	*_otherField;
		akButton	*_closeButton;
		akButton	*_insertAliasButton;
		akButton	*_modifyAliasButton;
		akButton	*_removeAliasButton;
		akButton	*_sortByAliasButton;
		akButton	*_sortByNameButton;
		akButton	*_sortByAddressButton;

		XtCallbackProc	_userCB;
		XtPointer	_userData;

		// Option callbacks

		static void	closeCB(Widget,XtPointer,XtPointer);
		static void	insertAliasCB(Widget,XtPointer,XtPointer);
		static void	modifyAliasCB(Widget,XtPointer,XtPointer);
		static void	removeAliasCB(Widget,XtPointer,XtPointer);
		static void	sortByAliasCB(Widget,XtPointer,XtPointer);
		static void	sortByNameCB(Widget,XtPointer,XtPointer);
		static void	sortByAddressCB(Widget,XtPointer,XtPointer);
		static void	addressChangedCB(Widget,XtPointer,XtPointer);
		static void	addressActionedCB(Widget,XtPointer,XtPointer);
		static void	composeClosedCB(Widget,XtPointer,XtPointer);
};


inline
const mxMailAddressBook&	mxMailAddressView::book()
	{return *_addressbook;}

#endif
#endif
