////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxFileViewer
//
//	Author : Andy Jefferson
//
//	Description :
//		mxFileViewer displays the contents of a text file.
//		The display takes the form of a text area, with Close, Print
//		and File buttons.
//
//	Public Methods :
//		(Constructor) requires :
//			name		The name used for resource specs
//			filename	The filename where it is stored.
//
//		refresh()	Refreshes the display.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxFileViewer_h
#define mxFileViewer_h
#ifdef __cplusplus

#include "akWindow.h"
#include "akButton.h"

class mxFileViewer : public akWindow
{
	public:

		// Constructor and destructor

		mxFileViewer(char *name,
			     string filename,
			     string filetext,
			     XtCallbackProc callback=0,
			     XtPointer clientData=0);
		~mxFileViewer();

		// Update facility

		void		update();

		void		manage();

	private:

		// The filename (and contents if passed in)

		string		_filename;
		string		_filetext;

		// Panel creation function/data

		Widget		createWorkArea(Widget);
		Widget		_textArea;
		akButton	*_closeButton;
		akButton	*_fileButton;
		akButton	*_printButton;

		// Callbacks for view panel options

		static void	closeCB(Widget,XtPointer,XtPointer);
		static void	fileCB(Widget,XtPointer,XtPointer);
		static void	printCB(Widget,XtPointer,XtPointer);

		static void	fileOK(XtPointer,XtPointer);
		static void	fileCANCEL(XtPointer,XtPointer);

		XtCallbackProc	_userCB;
		XtPointer	_userData;
};

#endif
#endif
