#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/ScrollBar.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>

#include "akApp.h"
#include "mxDirView.h"
#include "mxSetup.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxDirView::mxDirView(Widget parent,
		     char *name,
		     string directory,
		     string ls_output,
		     mxDirViewCB callback,
		     XtPointer clientData)
	:akComponent(name),
	 _fileList((akList *)0),
	 _dirList((akList *)0),
	 _userCB(callback),
	 _userData(clientData)
{
	Widget	pane;
	Widget	dir_frame;
	Widget	file_frame;

//	Create a form to attach contents to

	_w = XmCreateForm(parent,_name,NULL,0);
	installDestroyHandler();

	_currentDirLabel =
	  new akPromptString(_w,"CurrentDirLabel","");
	XtVaSetValues(_currentDirLabel->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      XmNalignment,XmALIGNMENT_BEGINNING,
		      0);
	XtVaSetValues(_currentDirLabel->fieldWidget(),
		      XmNmarginHeight,1,
		      XmNmarginWidth,2,
		      XmNeditable,FALSE,
		      XmNhighlightThickness,0,
		      XmNblinkRate,0,
		      0);
	_currentDirLabel->manage();
	pane =
		XtVaCreateManagedWidget("Pane",
					xmPanedWindowWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_WIDGET,
					XmNtopWidget,_currentDirLabel->baseWidget(),
					XmNleftAttachment,XmATTACH_FORM,
					XmNrightAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);

//	Add Directory list

	dir_frame =
		XtVaCreateManagedWidget("DirFrame",
					xmFrameWidgetClass,
					pane,
					XmNpaneMinimum,102,
					0);
	XtVaCreateManagedWidget("Directories",
				xmLabelWidgetClass,
				dir_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	_dirList =
	  new akList(dir_frame,"DirList",
		     &mxDirView::dirSelectedCB,
		     (XtPointer)this,
		     &mxDirView::dirActionedCB,
		     (XtPointer)this);
	_dirList->manage();

//	Add File list

	file_frame =
		XtVaCreateManagedWidget("FileFrame",
					xmFrameWidgetClass,
					pane,
					XmNpaneMinimum,105,
					0);
	XtVaCreateManagedWidget("Files",
				xmLabelWidgetClass,
				file_frame,
				XmNchildType,XmFRAME_TITLE_CHILD,
				0);
	_fileList =
	  new akList(file_frame,"fileList",
		     &mxDirView::fileSelectedCB,
		     (XtPointer)this);
	_fileList->setPolicy(MULTIPLE);
	_fileList->manage();

	update(directory,ls_output);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxDirView::~mxDirView()
{
	if (_currentDirLabel)
	  delete _currentDirLabel;
	if (_fileList)
	  delete _fileList;
	if (_dirList)
	  delete _dirList;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update display function - updated directory and ls output
//
////////////////////////////////////////////////////////////////////////////////
void	mxDirView::update(string directory,string ls_output)
{
	string	entry;
	int	file_start;
	int	pos1,pos2;
	int	permissionsStart,permissionsEnd;
	int	numberLinksStart,numberLinksEnd;
	int	ownerStart,ownerEnd;
	int	groupStart,groupEnd;
	int	sizeStart,sizeEnd;
	int	dateStart,dateEnd;

//	Save current directory and listing

	_directory = directory;
	_lsOutput  = ls_output;

//	Update directory label

	if (!_directory.empty())
	  _currentDirLabel->setValue(_directory);

//	Empty both lists

	_dirList->empty();
	_fileList->empty();

//	If NULL ls output return

	if (_lsOutput.empty())
	  return;

//	Bypass 'total' line

	pos2 = _lsOutput.find('\n');
	if (pos2 < 0)
	  return;
	pos1 = pos2+1;

//	Extract first entry and derive field widths

	int	pos,posa,posb;
	posa = pos1;
	posb = _lsOutput.find('\n',posa);
	entry.assign(_lsOutput,posa,posb-posa);

	// Permissions - find next blank
	permissionsStart = 0;
	permissionsEnd   = entry.find(" ");

	// NumberLinks - Find blank after non-blank
	numberLinksStart = permissionsEnd+1;
	posb = numberLinksStart;
	while ((pos = entry.find(" ",posb)) == posb)
	  posb++;
	if (pos < 0)
	  return;
	numberLinksEnd = pos;

	// Owner - Find start of group (non-blank)
	ownerStart = numberLinksEnd+1;
	posb = entry.find(" ",ownerStart);
	while ((pos = entry.find(" ",posb)) == posb)
	  posb++;
	if (pos < 0)
	  return;
	ownerEnd = posb-1;

	// Group - Assume same width for group as owner
	groupStart = ownerEnd+1;
	groupEnd   = groupStart+ownerEnd-ownerStart;

	// Size - Find blank after non-blank
	sizeStart = groupEnd+1;
	posb = sizeStart;
	while ((pos = entry.find(" ",posb)) == posb)
	  posb++;
	if (pos < 0)
	  return;
	sizeEnd = pos;

	// Date - Assume width is 12 (NEVER seen any system that it isn't !!)
	dateStart = sizeEnd+1;
	dateEnd   = dateStart+12;

	file_start = dateEnd+1;

//	Parse rest of list and add as directories or files

	while ((pos2 = _lsOutput.find('\n',pos1)) >= 0)
	  {
	   string	filename;
	   string	permissions;
	   string	numberlinks;
	   string	owner;
	   string	group;
	   string	size;
	   string	date;

	   entry.assign(_lsOutput,pos1,pos2-pos1);
	   permissions.assign(entry,permissionsStart,permissionsEnd-permissionsStart+1);
	   numberlinks.assign(entry,numberLinksStart,numberLinksEnd-numberLinksStart+1);
	   owner.assign(entry,ownerStart,ownerEnd-ownerStart+1);
	   group.assign(entry,groupStart,groupEnd-groupStart+1);
	   size.assign(entry,sizeStart,sizeEnd-sizeStart+1);
	   date.assign(entry,dateStart,dateEnd-dateStart+1);
	   filename.assign(entry,file_start,entry.size()-file_start);
	   if (filename[filename.size()-1] == '/' ||
	       filename[filename.size()-1] == '*' ||
	       filename[filename.size()-1] == '@' ||
	       filename[filename.size()-1] == '|' ||
	       filename[filename.size()-1] == '=')
	     filename.remove(filename.size()-1);

	   // Add directories displaying just the name (and symbolic link names)
	   if (entry[entry.size()-1] == '/')
	     _dirList->insert(filename);
	   // Add files showing required list features
	   else
	     {
	      string	file_entry;
	      if (theMxSetup->ftpShowPermissions())
		file_entry += permissions;
	      if (theMxSetup->ftpShowNumberLinks())
		file_entry += numberlinks;
	      if (theMxSetup->ftpShowOwner())
		file_entry += owner;
	      if (theMxSetup->ftpShowGroup())
		file_entry += group;
	      if (theMxSetup->ftpShowSize())
		file_entry += size;
	      if (theMxSetup->ftpShowDate())
		file_entry += date;
	      file_entry += filename;
	      _fileList->insert(file_entry);
	     }

	   pos1 = pos2+1;
	  }

//	Make sure that filename is in view

	Widget		*children;
	Cardinal	numChildren;
	int		value,slider,max,min;

	XtVaGetValues(_fileList->baseWidget(),
		      XmNchildren,&children,
		      XmNnumChildren,&numChildren,
		      0);
	for (int i=0;i<numChildren;i++)
	  {
	   if (strcmp(XtName(children[i]),"HorScrollBar") == 0)
	     {
	      XtVaGetValues(children[i],
			    XmNmaximum,&max,
			    XmNminimum,&min,
			    XmNvalue,&value,
			    XmNsliderSize,&slider,
			    0);
	      XmScrollBarSetValues(children[i],max-slider,0,0,0,TRUE);
	     }
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update display function - refresh display
//
////////////////////////////////////////////////////////////////////////////////
void	mxDirView::update()
{
	update(_directory,_lsOutput);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selected file access function
//
////////////////////////////////////////////////////////////////////////////////
string	*mxDirView::selectedFiles() const
{
	string	file;
	string	*selections;
	int	nselections;

	nselections = _fileList->noSelectedItems();
	if (nselections == 0)
	  return (string *)0;

	selections  = _fileList->selectedItems();
	for (int i=0;i<nselections;i++)
	  {
	   string	file=selections[i];

	   // Remove any linked files from selection - use the link
	   int	pos = file.rfind(" ");
	   if (pos >= 0)
	     file.remove(0,pos+1);
	   if (file[0] != '/')
	     {
	      if (_directory[_directory.size()-1] == '/')
		file.insert(0,_directory);
	      else
		{
		 file.insert(0,"/",1);
		 file.insert(0,_directory);
		}
	     }
	   selections[i] = file;
	  }

	return selections;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selected directory access function
//
////////////////////////////////////////////////////////////////////////////////
string	mxDirView::selectedDirectory() const
{
	string	dir;
	string	*selections;
	int	nselections;

	nselections = _dirList->noSelectedItems();
	if (nselections == 0)
	  return dir;

	selections  = _dirList->selectedItems();
	dir = selections[0];
	delete []selections;

//	Extract any linked directory name from the list entry

	int	pos = dir.rfind(" ");
	if (pos >= 0)
	  dir.remove(0,pos+1);

	if (dir == ".")
	  dir = _directory;
	else if (dir == "..")
	  {
	   dir = _directory;
	   pos = dir.rfind('/');
	   if (pos == 0)
	     dir = '/';
	   else
	     dir.remove(pos,dir.size()-pos);
	  }
	else if (dir[0] != '/')
	  {
	   if (_directory[_directory.size()-1] == '/')
	     dir.insert(0,_directory);
	   else
	     {
	      dir.insert(0,"/",1);
	      dir.insert(0,_directory);
	     }
	  }

	return dir;
}
////////////////////////////////////////////////////////////////////////////////
//
//	File selected callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxDirView::fileSelectedCB(Widget,XtPointer clientData,XtPointer)
{
	mxDirView	*obj = (mxDirView *)clientData;

	obj->_dirList->deselectAll();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Directory selected callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxDirView::dirSelectedCB(Widget,XtPointer clientData,XtPointer)
{
	mxDirView	*obj = (mxDirView *)clientData;

	obj->_fileList->deselectAll();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Directory actioned callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxDirView::dirActionedCB(Widget,XtPointer clientData,XtPointer)
{
	mxDirView	*obj = (mxDirView *)clientData;
	string		selection;

//	Call users callback

	selection = obj->selectedDirectory();
	if (obj->_userCB)
	  obj->_userCB(obj->_userData,selection);
}
