#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptString.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptString object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptString::akPromptString(Widget parent,
				 char *name,
				 string variable_name,
				 akPromptStringCB callback,
				 XtPointer clientData)
	: akPrompt(parent,name,variable_name)
{
	userCB = callback;
	userClientData = clientData;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value retrieval function
//
////////////////////////////////////////////////////////////////////////////////
string	akPromptString::value(void)
{
	string	temp_string;

//	Retrieve field string

	char	*field_string = XmTextFieldGetString(_field);
	if (field_string)
	  temp_string = field_string;
	XtFree(field_string);

	return temp_string;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptString::changeCB(string value)
{
	if (userCB != (akPromptStringCB)0)
	  (*userCB)(userClientData,value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptString::setValue(string new_value)
{
	if (!new_value.empty())
	  XmTextFieldSetString(_field,(char *)new_value.c_str());
	else
	  XmTextFieldSetString(_field,"");
}
