#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptDbles.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptDbles object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptDbles::akPromptDbles(Widget parent,
			       char *name,
			       string variable_name,
			       akPromptDblesCB callback,
			       XtPointer clientData)
	: akPrompt(parent,name,variable_name)
{
	userCB = callback;
	userClientData = clientData;

//	If a label prompt exists, change priority order so that the
//	label varies in size, and field is fixed size.

	if (_label != (Widget)0)
	  {
	   XtVaSetValues(_field,XmNleftAttachment,XmATTACH_NONE,NULL);
	   XtVaSetValues(_label,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_field,
			 NULL);
	  }

//	Set the initial value to be a single 0.0

	XmTextFieldSetString(_field,"0.0");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Pase Values from string
//
////////////////////////////////////////////////////////////////////////////////
double	*akPromptDbles::parseValues(const char *string,int *num_values)
{
	double	*values;
	char	*temp_string;
	int	i,j,point_no,last_point;
	bool	space;

//	Count number of values in string

	*num_values = 0;
	space = true;
	for (i=0;i<strlen(string);i++)
	  {
	   if (string[i]==' ' || string[i]==',')
	     space = true;
	   else
	     {
	      if (space) (*num_values)++;
	      space = false;
	     }
	  }

//	If No values, return NULL pointer

	if (*num_values == 0)
	  return (double *)0;

//	Values exist so allocate array of doubles

	values = new double[*num_values];

//	Read off doubles into array

	temp_string = new char[strlen(string)+1];
	temp_string[0] = '\0';
	point_no   = -1;
	last_point = -1;
	space = true;
	j = 0;
	for (i=0;i<strlen(string);i++)
	  {
	   if (string[i]==' ' || string[i] == ',')
	     {
	      if (!space)
	        {
	         values[point_no] = atof(temp_string);
		 last_point = point_no;
	        }
	      space = true;
	      j = 0;
	     }
	   else
	     {
	      temp_string[j] = string[i];j++;
	      temp_string[j] = '\0';
	      if (space) point_no++;
	      space = false;
	     }
	  }
	if (last_point < point_no)
	  values[point_no] = atof(temp_string);
	delete temp_string;

	return values;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Values retrieval function
//
////////////////////////////////////////////////////////////////////////////////
double	*akPromptDbles::value(int *num_values)
{
	char	*field_string;
	double	*values;

//	Retrieve field string

	field_string = XmTextFieldGetString(_field);

//	Parse the string for the values

	values = parseValues(field_string,num_values);

	return values;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbles::changeCB(string value)
{
	double	*values;
	int	num_values;

	if (userCB != (akPromptDblesCB)0)
	  {
	   values = parseValues(value.c_str(),&num_values);
	   (*userCB)(userClientData,values,num_values);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function for multiple values
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbles::setValue(double *new_values,int num_values)
{
	char	new_string[1000];
	char	temp_string[40];
	int	i;

	new_string[0] = '\0';
	if (num_values > 0)
	  {
	   sprintf(temp_string,"%g",new_values[0]);
	   strcat(new_string,temp_string);
	  }
	for (i=1;i<num_values;i++)
	  {
	   sprintf(temp_string,"  %g",new_values[i]);
	   strcat(new_string,temp_string);
	  }
	XmTextFieldSetString(_field,new_string);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function for single value
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbles::setValue(double new_value)
{
	char	temp_string[40];

	sprintf(temp_string,"%g",new_value);
	XmTextFieldSetString(_field,temp_string);
}
