#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptDbleRange.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptDbleRange object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptDbleRange::akPromptDbleRange(Widget parent,
				       char *name,
				       string variable_name,
				       akPromptDbleCB callback,
				       XtPointer clientData,
				       double lower,
				       double upper)
	: akPromptDble(parent,name,variable_name,callback,clientData)
{
	lower_range = lower;
	upper_range = upper;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Range update function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbleRange::setRange(double lower,double upper)
{
	double	double_value;

	lower_range = lower;
	upper_range = upper;

//	Reset value if now outside range

	double_value = value();
	if (double_value > upper_range)
	  setValue(upper_range);
	if (double_value < lower_range)
	  setValue(lower_range);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbleRange::changeCB(string value)
{
	double	double_value;

	double_value = atof(value.c_str());
	if (double_value > upper_range)
	  {
	   setValue(upper_range);
	   double_value = upper_range;
	  }
	if (double_value < lower_range)
	  {
	   setValue(lower_range);
	   double_value = lower_range;
	  }

	if (userCB != (akPromptDbleCB)0)
	  (*userCB)(userClientData,double_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptDbleRange::setValue(double new_value)
{
	char	new_string[100];

//	LIMITATION NOTE - new_string is size 100.

	if (new_value <= upper_range && new_value >= lower_range)
	  {
	   sprintf(new_string,"%g",new_value);
	   XmTextFieldSetString(_field,new_string);
	  }
}
