////////////////////////////////////////////////////////////////////////////////
//
//	Class : akLabel
//
//	Author : Andy Jefferson
//
//	Description :
//		akLabel represents an XmLabel widget, displaying either a
//		label or a pixmap.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget for the panel
//			name		Name used in resource specifications
//		either	pix		XPM represenation of pixmap
//		or	pix_width	Pixmap width
//			pix_height	Pixmap height
//			pix_bits	Pixmap bits
//		or	label		Label
//		setLabel()		Sets text label (label version only)
//		updatePixmap()		Updates the pixmap (XPM version only)
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akLabel_h
#define _akLabel_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akPixmap.h"
#include "akComponent.h"

class akLabel : public akComponent
{
	public:

		// Constructor/Destructor

		akLabel(Widget parent,		// Bitmap
			char *name,
			int pix_width,
			int pix_height,
			char pix_bits[]);
		akLabel(Widget parent,		// Pixmap
			char *name,
			char **pix);
		akLabel(Widget parent,		// Label
			char *name,
			string label);
		~akLabel(void);

		// Access functions

		void	setLabel(string);
		void	updatePixmap(akPixmap*);	// Pixmap

		// Class name

		virtual const char *const className(void)
			{return ("akLabel");}

	private:

		akPixmap	*_pixmap;
};

#endif
#endif
