#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/MwmUtil.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akLabel.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XBM
//
////////////////////////////////////////////////////////////////////////////////
akLabel::akLabel(Widget parent,
		 char *name,
		 int pix_width,
		 int pix_height,
		 char pix_bits[])
	: akComponent(name),
	  _pixmap((akPixmap *)0)
{
	Pixmap		pixmap,insens_pixmap;

//	Create label widget

	_w = XmCreateLabel(parent,_name,NULL,0);

//	Create the pixmap

	_pixmap = new akPixmap(pix_width,pix_height,pix_bits);
	pixmap = _pixmap->pixmap();
	insens_pixmap = _pixmap->insensitive();
	if (pixmap)
	  XtVaSetValues(_w,
			XmNlabelType,XmPIXMAP,
			XmNlabelPixmap,pixmap,
			XmNlabelInsensitivePixmap,insens_pixmap,
			NULL);

	installDestroyHandler();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - XPM
//
////////////////////////////////////////////////////////////////////////////////
akLabel::akLabel(Widget parent,
		 char *name,
		 char **pix)
	: akComponent(name),
	  _pixmap((akPixmap *)0)
{
	Pixmap		pixmap,insens_pixmap;

//	Create label widget

	_w = XmCreateLabel(parent,_name,NULL,0);

//	Create the pixmap

	_pixmap = new akPixmap(pix);
	pixmap = _pixmap->pixmap();
	insens_pixmap = _pixmap->insensitive();
	if (pixmap != (Pixmap)0)
	  XtVaSetValues(_w,
			XmNlabelType,XmPIXMAP,
			XmNlabelPixmap,pixmap,
			XmNlabelInsensitivePixmap,insens_pixmap,
			NULL);
	else
	  {
	   XmString tempstr=XmStringCreateLocalized("PixLabel");
	   XtVaSetValues(_w,
			 XmNlabelType,XmSTRING,
			 XmNlabelString,tempstr,
			 NULL);
	   XmStringFree(tempstr);
	  }

	installDestroyHandler();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function - Label
//
////////////////////////////////////////////////////////////////////////////////
akLabel::akLabel(Widget parent,
		 char *name,
		 string label)
	: akComponent(name),
	  _pixmap((akPixmap *)0)
{
	XmString	label_string;

//	Create label widget

	_w = XmCreateLabel(parent,_name,NULL,0);

	if (!label.empty())
	   {
	    label_string = XmStringCreateLtoR((char *)label.c_str(),XmFONTLIST_DEFAULT_TAG);
	    XtVaSetValues(_w,
			XmNlabelType,XmSTRING,
			XmNlabelString,label_string,
			0);
	    XmStringFree(label_string);
	   }

	installDestroyHandler();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akLabel::~akLabel()
{
	if (_pixmap != (akPixmap *)0)
	  delete _pixmap;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Label
//
////////////////////////////////////////////////////////////////////////////////
void	akLabel::setLabel(string new_label)
{
	XmString	tempstr;

	if (!new_label.empty())
	  {
	   tempstr = XmStringCreateLocalized((char *)new_label.c_str());
	   XtVaSetValues(_w,XmNlabelString,tempstr,0);
	   XmStringFree(tempstr);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Update Pixmap (primarily for animation purposes)
//
////////////////////////////////////////////////////////////////////////////////
void	akLabel::updatePixmap(akPixmap *pix)
{
	GC		gc;
	Dimension	widget_width,widget_height;
	int		x,y;
	Dimension	pixmap_width,pixmap_height;
	Cardinal	pixmap_depth;
	akPixmap	*oldpix;

	if (!XtWindow(_w))
	  return;
	if (!pix)
	  return;

	pix->extents(&pixmap_width,&pixmap_height,&pixmap_depth);

//	Set up a GC for the label

	gc = XCreateGC(XtDisplay(_w),XtWindow(_w),0,NULL);
	XSetFunction(XtDisplay(_w),gc,GXcopy);

//	Set up position of pixmap in label

	XtVaGetValues(_w,
		      XmNwidth,&widget_width,
		      XmNheight,&widget_height,
		      NULL);
	x = (widget_width  - pixmap_width)/2;
	y = (widget_height - pixmap_height)/2;
	if (x < 0) x = 0;
	if (y < 0) y = 0;

//	Copy the new pixmap into the pixmap and the label

	XCopyArea(XtDisplay(_w),pix->pixmap(),_pixmap->pixmap(),gc,
		  0,0,pixmap_width,pixmap_height,x,y);
	XCopyArea(XtDisplay(_w),pix->pixmap(),XtWindow(_w),gc,
		  0,0,pixmap_width,pixmap_height,x,y);

//	Free off the GC

	XFreeGC(XtDisplay(_w),gc);
}
