////////////////////////////////////////////////////////////////////////////////
//
//	Class : akDocView
//
//	Author : Andy Jefferson
//
//	Description :
//		The akDocView class provides a graphical representation
//		(view) of a document. It produces a panel consisting of a
//		list of sections, and a section viewing area showing the
//		currently selected sections text. It is derived from the
//		akSecWindow class as well as the akDocument class.
//
//		The access function "selectSection" allows selection
//		of a document section programmatically. The section_no
//		has an origin of 0. Use of this function selects the
//		section in the list, and displays the text for that section.
//
//	Public Methods :
//
//	Limitations :
//		Doesn't allow use of different fonts/colors.
//		Doesn't allow use of hypertext.
//		Doesn't allow inclusion of figures within the text.
//		When panel resized, doesn't adjust line ends.
//
//		Better way would be to get rid of akDoc, and just pass HTML file
//		to akDocView. Get it to parse the file, and whenever get to
//		a HTML tag, to set certain things (e.g font, position). Main
//		widget will be a drawing area. Will need to remove all line
//		ends, and check when adding strings etc the line width. Then
//		continue adding until come across next HTML tag, when you set
//		certain things again etc. That way you will be able to cater
//		for figures within the text etc.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akDocView_h
#define _akDocView_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akDoc.h"
#include "akWindow.h"
#include "akButton.h"

class akDocView : public akWindow
{
	public:

		// Constructor

		akDocView(char *name,
			  string filename);

		// Access functions

		virtual const char *const className(void)
			{return ("akDocView");}

		void		selectSection(int section_no);

	private:

		// Data members used by class

		Widget		_sectionList;
		Widget		_textArea;
		Widget		_textLabel;
		int		_currentSectionNo;
		akButton	*_closeButton;
		akDoc		*_document;

		// Private functions used in panel etc

		Widget		createWorkArea(Widget parent);
		void		addListItem(int item_no);
		static	void	listItemChanged(Widget,XtPointer,XtPointer);
		static	void	closeCB(Widget,XtPointer,XtPointer);
};

#endif
#endif
