////////////////////////////////////////////////////////////////////////////////
//
//	Class : akCopyright
//	
//	Author : Andy Jefferson
//
//	Description :
//	This header file contains the description of the akCopyright object.
//	The user specifies a pixmap to represent the application, together with
//	the company name, and the year of copyright.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akCopyright_h
#define _akCopyright_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include "akPixmap.h"
#include "akDialog.h"

class	akCopyright : public akDialog
{
	public:

//		Constructor

		akCopyright(Widget parent,		// Bitmap
			    char *name,
			    char *company,
			    char *year,
			    int bitmap_width,
			    int bitmap_height,
			    char bitmap_bits[]);
		akCopyright(Widget parent,		// Pixmap
			    char *name,
			    char *company,
			    char *year,
			    char **pix);

	private:

//		Panel creation function and callbacks

		Widget		createWorkArea(Widget parent);
		static	void	closeCB(Widget,XtPointer,XtPointer);	

		char		*companyName;
		char		*copyrightYear;
		Widget		app_pixmap;
		akPixmap	*_pixmap;
};

#endif
#endif
