////////////////////////////////////////////////////////////////////////////////
//
//	Class : akCheckBox
//
//	Author : Andy Jefferson
//
//	Description :
//		The akCheckBox class provides a check box of options
//		of which the user can select any number at any time.
//		It allows the user to extract the status of all options
//		as well as providing a callback hook to allow
//		dynamic notification of changes in selections.
//		The user controls the layout of the check box options
//		by way of the 'num_columns' input item. The options
//		are always layed out in a rectangular grid. The
//		'num_columns' input item determines how many columns
//		there are.
//		Whenever an option is changed, the "callback" is
//		invoked - allowing dynamic response to a users input.
//		The "callback" is passed the "clientData" as well as
//		a akCheckBoxCallbackStruct (as "callData"). The
//		akCheckBoxCallbackStruct provides the option_no changed
//		as well as the value it is changed to. The option no
//		ranges from 0 to num_options-1.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			options		Options in check-box
//			num_options	Number of options
//			num_cols	Number of columns in display
//			callback	Callback called when option changed
//			clientData	Data passed to callback
//		set()		Select an option
//		unset()		De-select an option
//		selected()	Is an option selected ?
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akCheckBox_h
#define _akCheckBox_h
#ifdef __cplusplus

#include <Xm/Xm.h>
#include <bool.h>
#include "akComponent.h"

typedef struct
{
	int	option_no;
	bool	value;
} akCheckBoxCallbackStruct;
////////////////////////////////////////////////////////////////////////////////
class akCheckBox : public akComponent
{
	public:

		// Constructor

		akCheckBox(Widget parent,
			    char *name,
			    char *prompt,
			    char **options,
			    int num_options,
			    int num_columns=1,
			    XtCallbackProc callback=(XtCallbackProc)0,
			    XtPointer clientData=(XtPointer)0);
		~akCheckBox();

		// Access functions

		void	set(int option_no);		// Select the option
		void	unset(int option_no);		// Deselect the option
		bool	selected(int option_no);	// Is option selected ?

		// Class name

		virtual const char *const className(void)
			{return ("akCheckBox");}

	private:

		Widget		_checkBox;
		int		_numOptions;
		Widget		optionWidget(int option_no);

		static	void	changeCB(Widget,XtPointer,XtPointer);

		akCheckBoxCallbackStruct	*_callbackStruct;

		XtCallbackProc	_userCB;
		XtPointer	_userData;
};

#endif
#endif
