/*
 * resource.c
 *	Connect resources to a list of widgets.  This file is part of wlib.
 *
 * Copyright (C) 1996  Matthew D. Francey
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
/*
 * connect resources to a list of widgets
 *
 * resource file use is preferred, but sometimes this is inescapable...
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: wlib/resource.c,v 1.19 $")

#include	<Xm/Xm.h>

#include	<wlib/wlib.h>

void
wl_resource(Widget parent, WLR *r)
{
	WLR		*lr;
	Widget		w;
	Cardinal	n;
	Arg		a[64];
	XtPointer	v;
	XmString	s[64];
	int		ns;

	lr = NULL;
	w  = NULL;
	n  = 0;
	ns = 0;
	memset((void *)s, '\0', sizeof(s));
	for(;;) {
		if(lr == NULL
		|| r->name == NULL
		|| strcmp(lr->name, r->name) != 0) {
			if(w != NULL && n != 0)
				XtSetValues(w, &a[0], n);
			while(--ns >= 0)
				XmStringFree(s[ns]);
			if(r->name == NULL)
				break;
			n  = 0;
			ns = 0;
			w  = XtNameToWidget(parent, r->name);
		}
		lr = r++;
		if(w == NULL)
			continue;
		v = r->value;
		switch(lr->type) {
		case WL_DIRECT:
			break;
		case WL_INDIRECT:
			v = (XtPointer)XtNameToWidget(parent,(char*)v);
			break;
		case WL_STRINGXM:
			v = (XtPointer)XmStringCreateLocalized((char *)v);
			if(v == NULL)
				continue;
			s[ns++] = (XmString) v;
			break;
		default:
			break;
		}
		XtSetArg(a[n], lr->res, v);	++n;
	}
}
