#!@@PERL@@ -w
# $Mu: tools/txt2swh.pl,v 1.10 $
##
## txt2swh.pl
##	Formatted (by sgml2txt -f) text to switch help array tool.
##
## Copyright (C) 1997 Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:  Eric A. Howe (mu@echo-on.net)
##

##
## tools/yanksect --section 'Command Line Switches' < doc/mgv.sgml > _swh.sgml
## sgml2txt -f _swh.sgml
## tools/txt2swh < _swh.txt > _switch_help.h
## rm -f _swh.sgml _swh.txt
##
use strict;

sub main() {
	my $line;
	my $switch;
	my %help;
	my @switches;
	my @help = ();
	my @parts;

	while(defined($line = <>)) {
		chomp($line);
		if($line =~ m(^     -)) {
			$line          =~ s/^\s+//;
			$line          =~ s/"/\\"/g;
			$switch        = $line;
			$help{$switch} = [ ];

			@parts = split(/, /, $switch);
			if($#parts == 0) {
				push(@switches, $switch);
			}
			elsif($parts[1] eq "-no" . substr($parts[0], 1)) {
				push(@switches, "-[no]" . substr($parts[0], 1));
			}
			else {
				push(@switches, @parts);
			}
		}
		elsif($line =~ /^        (.*)/) {
			push(@{$help{$switch}}, "\"\\t$1\",");
		}
	}

	print "/*\n * Generated file, hands off!\n */\n";
	print "char *bld_switch_longhelp[] = {\n";
	foreach $switch (sort keys %help) {
		print "\"$switch\",\n";
		print "\t", join("\n\t", @{$help{$switch}}), "\n";
	}
	print "(char *)0\n};\n\n";

	##
	## We put the -help and -longhelp switches at the front
	## so that they will (hopefully) be easy to find in the
	## shorter -help listing.  God I love grep!
	##
	@switches = grep {
			$_ = "\"[$_]\"";
			$_ =~ /^\"\[(-help|-longhelp)\]\"$/
				? (push(@help, $_), 0)
				: 1
		} sort @switches;
	unshift(@switches, @help);
	print "char *bld_switch_help[] = {\n";
	print join(",\n", @switches);
	print ",\n(char *)0\n};\n";

	return 0;
}

exit(main());
